/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CocoaDecorator
extends TreeDecorator {
    public static final MapCodec<CocoaDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(CocoaDecorator::new, var0 -> Float.valueOf(var0.probability));
    private final float probability;

    public CocoaDecorator(float var0) {
        this.probability = var0;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.COCOA;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        RandomSource var12 = var0.random();
        if (var12.nextFloat() >= this.probability) {
            return;
        }
        ObjectArrayList<BlockPos> var22 = var0.logs();
        if (var22.isEmpty()) {
            return;
        }
        int var3 = ((BlockPos)var22.getFirst()).getY();
        var22.stream().filter(var1 -> var1.getY() - var3 <= 2).forEach(var2 -> {
            for (Direction var4 : Direction.Plane.HORIZONTAL) {
                Direction var5;
                BlockPos var6;
                if (!(var12.nextFloat() <= 0.25f) || !var0.isAir(var6 = var2.offset((var5 = var4.getOpposite()).getStepX(), 0, var5.getStepZ()))) continue;
                var0.setBlock(var6, (BlockState)((BlockState)Blocks.COCOA.defaultBlockState().setValue(CocoaBlock.AGE, var12.nextInt(3))).setValue(CocoaBlock.FACING, var4));
            }
        });
    }
}

