/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public abstract class TreeDecorator {
    public static final Codec<TreeDecorator> CODEC = BuiltInRegistries.TREE_DECORATOR_TYPE.byNameCodec().dispatch(TreeDecorator::type, TreeDecoratorType::codec);

    protected abstract TreeDecoratorType<?> type();

    public abstract void place(Context var1);

    public static final class Context {
        private final LevelSimulatedReader level;
        private final BiConsumer<BlockPos, BlockState> decorationSetter;
        private final RandomSource random;
        private final ObjectArrayList<BlockPos> logs;
        private final ObjectArrayList<BlockPos> leaves;
        private final ObjectArrayList<BlockPos> roots;

        public Context(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, Set<BlockPos> var3, Set<BlockPos> var4, Set<BlockPos> var5) {
            this.level = var0;
            this.decorationSetter = var1;
            this.random = var2;
            this.roots = new ObjectArrayList(var5);
            this.logs = new ObjectArrayList(var3);
            this.leaves = new ObjectArrayList(var4);
            this.logs.sort(Comparator.comparingInt(Vec3i::getY));
            this.leaves.sort(Comparator.comparingInt(Vec3i::getY));
            this.roots.sort(Comparator.comparingInt(Vec3i::getY));
        }

        public void placeVine(BlockPos var0, BooleanProperty var1) {
            this.setBlock(var0, (BlockState)Blocks.VINE.defaultBlockState().setValue(var1, true));
        }

        public void setBlock(BlockPos var0, BlockState var1) {
            this.decorationSetter.accept(var0, var1);
        }

        public boolean isAir(BlockPos var0) {
            return this.level.isStateAtPosition(var0, BlockBehaviour.BlockStateBase::isAir);
        }

        public boolean checkBlock(BlockPos var0, Predicate<BlockState> var1) {
            return this.level.isStateAtPosition(var0, var1);
        }

        public LevelSimulatedReader level() {
            return this.level;
        }

        public RandomSource random() {
            return this.random;
        }

        public ObjectArrayList<BlockPos> logs() {
            return this.logs;
        }

        public ObjectArrayList<BlockPos> leaves() {
            return this.leaves;
        }

        public ObjectArrayList<BlockPos> roots() {
            return this.roots;
        }
    }
}

