/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BendingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<BendingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> BendingTrunkPlacer.trunkPlacerParts(var02).and(var02.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("min_height_for_leaves", (Object)1).forGetter(var0 -> var0.minHeightForLeaves), (App)IntProvider.codec(1, 64).fieldOf("bend_length").forGetter(var0 -> var0.bendLength))).apply((Applicative)var02, BendingTrunkPlacer::new));
    private final int minHeightForLeaves;
    private final IntProvider bendLength;

    public BendingTrunkPlacer(int var0, int var1, int var2, int var3, IntProvider var4) {
        super(var0, var1, var2);
        this.minHeightForLeaves = var3;
        this.bendLength = var4;
    }

    @Override
    protected TrunkPlacerType<?> type() {
        return TrunkPlacerType.BENDING_TRUNK_PLACER;
    }

    @Override
    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, int var3, BlockPos var4, TreeConfiguration var5) {
        int var11;
        Direction var6 = Direction.Plane.HORIZONTAL.getRandomDirection(var2);
        int var7 = var3 - 1;
        BlockPos.MutableBlockPos var8 = var4.mutable();
        Vec3i var9 = var8.below();
        BendingTrunkPlacer.setDirtAt(var0, var1, var2, (BlockPos)var9, var5);
        ArrayList var10 = Lists.newArrayList();
        for (var11 = 0; var11 <= var7; ++var11) {
            if (var11 + 1 >= var7 + var2.nextInt(2)) {
                var8.move(var6);
            }
            if (TreeFeature.validTreePos(var0, var8)) {
                this.placeLog(var0, var1, var2, var8, var5);
            }
            if (var11 >= this.minHeightForLeaves) {
                var10.add(new FoliagePlacer.FoliageAttachment(var8.immutable(), 0, false));
            }
            var8.move(Direction.UP);
        }
        var11 = this.bendLength.sample(var2);
        for (int var12 = 0; var12 <= var11; ++var12) {
            if (TreeFeature.validTreePos(var0, var8)) {
                this.placeLog(var0, var1, var2, var8, var5);
            }
            var10.add(new FoliagePlacer.FoliageAttachment(var8.immutable(), 0, false));
            var8.move(var6);
        }
        return var10;
    }
}

