/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightmapPlacement
extends PlacementModifier {
    public static final MapCodec<HeightmapPlacement> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Heightmap.Types.CODEC.fieldOf("heightmap").forGetter(var0 -> var0.heightmap)).apply((Applicative)var02, HeightmapPlacement::new));
    private final Heightmap.Types heightmap;

    private HeightmapPlacement(Heightmap.Types var0) {
        this.heightmap = var0;
    }

    public static HeightmapPlacement onHeightmap(Heightmap.Types var0) {
        return new HeightmapPlacement(var0);
    }

    @Override
    public Stream<BlockPos> getPositions(PlacementContext var0, RandomSource var1, BlockPos var2) {
        int var4;
        int var3 = var2.getX();
        int var5 = var0.getHeight(this.heightmap, var3, var4 = var2.getZ());
        if (var5 > var0.getMinY()) {
            return Stream.of(new BlockPos(var3, var5, var4));
        }
        return Stream.of(new BlockPos[0]);
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.HEIGHTMAP;
    }
}

