/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import org.slf4j.Logger;

public class BoundingBox {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BoundingBox> CODEC = Codec.INT_STREAM.comapFlatMap(var02 -> Util.fixedSize(var02, 6).map(var0 -> new BoundingBox(var0[0], var0[1], var0[2], var0[3], var0[4], var0[5])), var0 -> IntStream.of(var0.minX, var0.minY, var0.minZ, var0.maxX, var0.maxY, var0.maxZ)).stable();
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    public BoundingBox(BlockPos var0) {
        this(var0.getX(), var0.getY(), var0.getZ(), var0.getX(), var0.getY(), var0.getZ());
    }

    public BoundingBox(int var0, int var1, int var2, int var3, int var4, int var5) {
        this.minX = var0;
        this.minY = var1;
        this.minZ = var2;
        this.maxX = var3;
        this.maxY = var4;
        this.maxZ = var5;
        if (var3 < var0 || var4 < var1 || var5 < var2) {
            Util.logAndPauseIfInIde("Invalid bounding box data, inverted bounds for: " + String.valueOf(this));
            this.minX = Math.min(var0, var3);
            this.minY = Math.min(var1, var4);
            this.minZ = Math.min(var2, var5);
            this.maxX = Math.max(var0, var3);
            this.maxY = Math.max(var1, var4);
            this.maxZ = Math.max(var2, var5);
        }
    }

    public static BoundingBox fromCorners(Vec3i var0, Vec3i var1) {
        return new BoundingBox(Math.min(var0.getX(), var1.getX()), Math.min(var0.getY(), var1.getY()), Math.min(var0.getZ(), var1.getZ()), Math.max(var0.getX(), var1.getX()), Math.max(var0.getY(), var1.getY()), Math.max(var0.getZ(), var1.getZ()));
    }

    public static BoundingBox infinite() {
        return new BoundingBox(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public static BoundingBox orientBox(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, Direction var9) {
        switch (var9) {
            default: {
                return new BoundingBox(var0 + var3, var1 + var4, var2 + var5, var0 + var6 - 1 + var3, var1 + var7 - 1 + var4, var2 + var8 - 1 + var5);
            }
            case NORTH: {
                return new BoundingBox(var0 + var3, var1 + var4, var2 - var8 + 1 + var5, var0 + var6 - 1 + var3, var1 + var7 - 1 + var4, var2 + var5);
            }
            case WEST: {
                return new BoundingBox(var0 - var8 + 1 + var5, var1 + var4, var2 + var3, var0 + var5, var1 + var7 - 1 + var4, var2 + var6 - 1 + var3);
            }
            case EAST: 
        }
        return new BoundingBox(var0 + var5, var1 + var4, var2 + var3, var0 + var8 - 1 + var5, var1 + var7 - 1 + var4, var2 + var6 - 1 + var3);
    }

    public Stream<ChunkPos> intersectingChunks() {
        int var0 = SectionPos.blockToSectionCoord(this.minX());
        int var1 = SectionPos.blockToSectionCoord(this.minZ());
        int var2 = SectionPos.blockToSectionCoord(this.maxX());
        int var3 = SectionPos.blockToSectionCoord(this.maxZ());
        return ChunkPos.rangeClosed(new ChunkPos(var0, var1), new ChunkPos(var2, var3));
    }

    public boolean intersects(BoundingBox var0) {
        return this.maxX >= var0.minX && this.minX <= var0.maxX && this.maxZ >= var0.minZ && this.minZ <= var0.maxZ && this.maxY >= var0.minY && this.minY <= var0.maxY;
    }

    public boolean intersects(int var0, int var1, int var2, int var3) {
        return this.maxX >= var0 && this.minX <= var2 && this.maxZ >= var1 && this.minZ <= var3;
    }

    public static Optional<BoundingBox> encapsulatingPositions(Iterable<BlockPos> var0) {
        Iterator<BlockPos> var1 = var0.iterator();
        if (!var1.hasNext()) {
            return Optional.empty();
        }
        BoundingBox var2 = new BoundingBox(var1.next());
        var1.forEachRemaining(var2::encapsulate);
        return Optional.of(var2);
    }

    public static Optional<BoundingBox> encapsulatingBoxes(Iterable<BoundingBox> var0) {
        Iterator<BoundingBox> var1 = var0.iterator();
        if (!var1.hasNext()) {
            return Optional.empty();
        }
        BoundingBox var2 = var1.next();
        BoundingBox var3 = new BoundingBox(var2.minX, var2.minY, var2.minZ, var2.maxX, var2.maxY, var2.maxZ);
        var1.forEachRemaining(var3::encapsulate);
        return Optional.of(var3);
    }

    @Deprecated
    public BoundingBox encapsulate(BoundingBox var0) {
        this.minX = Math.min(this.minX, var0.minX);
        this.minY = Math.min(this.minY, var0.minY);
        this.minZ = Math.min(this.minZ, var0.minZ);
        this.maxX = Math.max(this.maxX, var0.maxX);
        this.maxY = Math.max(this.maxY, var0.maxY);
        this.maxZ = Math.max(this.maxZ, var0.maxZ);
        return this;
    }

    @Deprecated
    public BoundingBox encapsulate(BlockPos var0) {
        this.minX = Math.min(this.minX, var0.getX());
        this.minY = Math.min(this.minY, var0.getY());
        this.minZ = Math.min(this.minZ, var0.getZ());
        this.maxX = Math.max(this.maxX, var0.getX());
        this.maxY = Math.max(this.maxY, var0.getY());
        this.maxZ = Math.max(this.maxZ, var0.getZ());
        return this;
    }

    @Deprecated
    public BoundingBox move(int var0, int var1, int var2) {
        this.minX += var0;
        this.minY += var1;
        this.minZ += var2;
        this.maxX += var0;
        this.maxY += var1;
        this.maxZ += var2;
        return this;
    }

    @Deprecated
    public BoundingBox move(Vec3i var0) {
        return this.move(var0.getX(), var0.getY(), var0.getZ());
    }

    public BoundingBox moved(int var0, int var1, int var2) {
        return new BoundingBox(this.minX + var0, this.minY + var1, this.minZ + var2, this.maxX + var0, this.maxY + var1, this.maxZ + var2);
    }

    public BoundingBox inflatedBy(int var0) {
        return this.inflatedBy(var0, var0, var0);
    }

    public BoundingBox inflatedBy(int var0, int var1, int var2) {
        return new BoundingBox(this.minX() - var0, this.minY() - var1, this.minZ() - var2, this.maxX() + var0, this.maxY() + var1, this.maxZ() + var2);
    }

    public boolean isInside(Vec3i var0) {
        return this.isInside(var0.getX(), var0.getY(), var0.getZ());
    }

    public boolean isInside(int var0, int var1, int var2) {
        return var0 >= this.minX && var0 <= this.maxX && var2 >= this.minZ && var2 <= this.maxZ && var1 >= this.minY && var1 <= this.maxY;
    }

    public Vec3i getLength() {
        return new Vec3i(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public int getXSpan() {
        return this.maxX - this.minX + 1;
    }

    public int getYSpan() {
        return this.maxY - this.minY + 1;
    }

    public int getZSpan() {
        return this.maxZ - this.minZ + 1;
    }

    public BlockPos getCenter() {
        return new BlockPos(this.minX + (this.maxX - this.minX + 1) / 2, this.minY + (this.maxY - this.minY + 1) / 2, this.minZ + (this.maxZ - this.minZ + 1) / 2);
    }

    public void forAllCorners(Consumer<BlockPos> var0) {
        BlockPos.MutableBlockPos var1 = new BlockPos.MutableBlockPos();
        var0.accept(var1.set(this.maxX, this.maxY, this.maxZ));
        var0.accept(var1.set(this.minX, this.maxY, this.maxZ));
        var0.accept(var1.set(this.maxX, this.minY, this.maxZ));
        var0.accept(var1.set(this.minX, this.minY, this.maxZ));
        var0.accept(var1.set(this.maxX, this.maxY, this.minZ));
        var0.accept(var1.set(this.minX, this.maxY, this.minZ));
        var0.accept(var1.set(this.maxX, this.minY, this.minZ));
        var0.accept(var1.set(this.minX, this.minY, this.minZ));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minX", this.minX).add("minY", this.minY).add("minZ", this.minZ).add("maxX", this.maxX).add("maxY", this.maxY).add("maxZ", this.maxZ).toString();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof BoundingBox) {
            BoundingBox var1 = (BoundingBox)var0;
            return this.minX == var1.minX && this.minY == var1.minY && this.minZ == var1.minZ && this.maxX == var1.maxX && this.maxY == var1.maxY && this.maxZ == var1.maxZ;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public int minX() {
        return this.minX;
    }

    public int minY() {
        return this.minY;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxY() {
        return this.maxY;
    }

    public int maxZ() {
        return this.maxZ;
    }
}

