/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class ListPoolElement
extends StructurePoolElement {
    public static final MapCodec<ListPoolElement> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)StructurePoolElement.CODEC.listOf().fieldOf("elements").forGetter(var0 -> var0.elements), ListPoolElement.projectionCodec()).apply((Applicative)var02, ListPoolElement::new));
    private final List<StructurePoolElement> elements;

    public ListPoolElement(List<StructurePoolElement> var0, StructureTemplatePool.Projection var1) {
        super(var1);
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("Elements are empty");
        }
        this.elements = var0;
        this.setProjectionOnEachElement(var1);
    }

    @Override
    public Vec3i getSize(StructureTemplateManager var0, Rotation var1) {
        int var2 = 0;
        int var3 = 0;
        int var4 = 0;
        for (StructurePoolElement var6 : this.elements) {
            Vec3i var7 = var6.getSize(var0, var1);
            var2 = Math.max(var2, var7.getX());
            var3 = Math.max(var3, var7.getY());
            var4 = Math.max(var4, var7.getZ());
        }
        return new Vec3i(var2, var3, var4);
    }

    @Override
    public List<StructureTemplate.JigsawBlockInfo> getShuffledJigsawBlocks(StructureTemplateManager var0, BlockPos var1, Rotation var2, RandomSource var3) {
        return this.elements.get(0).getShuffledJigsawBlocks(var0, var1, var2, var3);
    }

    @Override
    public BoundingBox getBoundingBox(StructureTemplateManager var02, BlockPos var1, Rotation var2) {
        Stream<BoundingBox> var32 = this.elements.stream().filter(var0 -> var0 != EmptyPoolElement.INSTANCE).map(var3 -> var3.getBoundingBox(var02, var1, var2));
        return BoundingBox.encapsulatingBoxes(var32::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox for ListPoolElement"));
    }

    @Override
    public boolean place(StructureTemplateManager var0, WorldGenLevel var1, StructureManager var2, ChunkGenerator var3, BlockPos var4, BlockPos var5, Rotation var6, BoundingBox var7, RandomSource var8, LiquidSettings var9, boolean var10) {
        for (StructurePoolElement var12 : this.elements) {
            if (var12.place(var0, var1, var2, var3, var4, var5, var6, var7, var8, var9, var10)) continue;
            return false;
        }
        return true;
    }

    @Override
    public StructurePoolElementType<?> getType() {
        return StructurePoolElementType.LIST;
    }

    @Override
    public StructurePoolElement setProjection(StructureTemplatePool.Projection var0) {
        super.setProjection(var0);
        this.setProjectionOnEachElement(var0);
        return this;
    }

    public String toString() {
        return "List[" + this.elements.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private void setProjectionOnEachElement(StructureTemplatePool.Projection var0) {
        this.elements.forEach(var1 -> var1.setProjection(var0));
    }

    @VisibleForTesting
    public List<StructurePoolElement> getElements() {
        return this.elements;
    }
}

