/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilPieces;

public class NetherFossilStructure
extends Structure {
    public static final MapCodec<NetherFossilStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(NetherFossilStructure.settingsCodec(var02), (App)HeightProvider.CODEC.fieldOf("height").forGetter(var0 -> var0.height)).apply((Applicative)var02, NetherFossilStructure::new));
    public final HeightProvider height;

    public NetherFossilStructure(Structure.StructureSettings var0, HeightProvider var1) {
        super(var0);
        this.height = var1;
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        Object var9;
        WorldgenRandom var1 = var0.random();
        int var2 = var0.chunkPos().getMinBlockX() + var1.nextInt(16);
        int var3 = var0.chunkPos().getMinBlockZ() + var1.nextInt(16);
        int var4 = var0.chunkGenerator().getSeaLevel();
        WorldGenerationContext var5 = new WorldGenerationContext(var0.chunkGenerator(), var0.heightAccessor());
        int var6 = this.height.sample(var1, var5);
        NoiseColumn var7 = var0.chunkGenerator().getBaseColumn(var2, var3, var0.heightAccessor(), var0.randomState());
        BlockPos.MutableBlockPos var8 = new BlockPos.MutableBlockPos(var2, var6, var3);
        while (var6 > var4) {
            var9 = var7.getBlock(var6);
            BlockState var10 = var7.getBlock(--var6);
            if (!((BlockBehaviour.BlockStateBase)var9).isAir() || !var10.is(Blocks.SOUL_SAND) && !var10.isFaceSturdy(EmptyBlockGetter.INSTANCE, var8.setY(var6), Direction.UP)) continue;
            break;
        }
        if (var6 <= var4) {
            return Optional.empty();
        }
        var9 = new BlockPos(var2, var6, var3);
        return Optional.of(new Structure.GenerationStub((BlockPos)var9, arg_0 -> NetherFossilStructure.lambda$findGenerationPoint$2(var0, var1, (BlockPos)var9, arg_0)));
    }

    @Override
    public StructureType<?> type() {
        return StructureType.NETHER_FOSSIL;
    }

    private static /* synthetic */ void lambda$findGenerationPoint$2(Structure.GenerationContext var0, WorldgenRandom var1, BlockPos var2, StructurePiecesBuilder var3) {
        NetherFossilPieces.addPieces(var0.structureTemplateManager(), var3, var1, var2);
    }
}

