/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinPieces;

public class OceanRuinStructure
extends Structure {
    public static final MapCodec<OceanRuinStructure> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group(OceanRuinStructure.settingsCodec(var02), (App)Type.CODEC.fieldOf("biome_temp").forGetter(var0 -> var0.biomeTemp), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("large_probability").forGetter(var0 -> Float.valueOf(var0.largeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("cluster_probability").forGetter(var0 -> Float.valueOf(var0.clusterProbability))).apply((Applicative)var02, OceanRuinStructure::new));
    public final Type biomeTemp;
    public final float largeProbability;
    public final float clusterProbability;

    public OceanRuinStructure(Structure.StructureSettings var0, Type var1, float var2, float var3) {
        super(var0);
        this.biomeTemp = var1;
        this.largeProbability = var2;
        this.clusterProbability = var3;
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext var0) {
        return OceanRuinStructure.onTopOfChunkCenter(var0, Heightmap.Types.OCEAN_FLOOR_WG, var1 -> this.generatePieces((StructurePiecesBuilder)var1, var0));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.GenerationContext var1) {
        BlockPos var2 = new BlockPos(var1.chunkPos().getMinBlockX(), 90, var1.chunkPos().getMinBlockZ());
        Rotation var3 = Rotation.getRandom(var1.random());
        OceanRuinPieces.addPieces(var1.structureTemplateManager(), var2, var3, var0, var1.random(), this);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.OCEAN_RUIN;
    }

    public static enum Type implements StringRepresentable
    {
        WARM("warm"),
        COLD("cold");

        public static final Codec<Type> CODEC;
        @Deprecated
        public static final Codec<Type> LEGACY_CODEC;
        private final String name;

        private Type(String var2) {
            this.name = var2;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
            LEGACY_CODEC = ExtraCodecs.legacyEnum(Type::valueOf);
        }
    }
}

