/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftLootable;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R5.util.TransformerGeneratorAccess;
import org.slf4j.Logger;

public class StructureTemplate {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String PALETTE_TAG = "palette";
    public static final String PALETTE_LIST_TAG = "palettes";
    public static final String ENTITIES_TAG = "entities";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BLOCK_TAG_POS = "pos";
    public static final String BLOCK_TAG_STATE = "state";
    public static final String BLOCK_TAG_NBT = "nbt";
    public static final String ENTITY_TAG_POS = "pos";
    public static final String ENTITY_TAG_BLOCKPOS = "blockPos";
    public static final String ENTITY_TAG_NBT = "nbt";
    public static final String SIZE_TAG = "size";
    public final List<Palette> palettes = Lists.newArrayList();
    public final List<StructureEntityInfo> entityInfoList = Lists.newArrayList();
    private Vec3i size;
    private String author = "?";
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public StructureTemplate() {
        this.size = Vec3i.ZERO;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public void setAuthor(String s) {
        this.author = s;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fillFromWorld(Level world, BlockPos blockposition, Vec3i baseblockposition, boolean flag, List<Block> list) {
        if (baseblockposition.getX() >= 1 && baseblockposition.getY() >= 1 && baseblockposition.getZ() >= 1) {
            BlockPos blockposition1 = blockposition.offset(baseblockposition).offset(-1, -1, -1);
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            ArrayList list3 = Lists.newArrayList();
            BlockPos blockposition2 = new BlockPos(Math.min(blockposition.getX(), blockposition1.getX()), Math.min(blockposition.getY(), blockposition1.getY()), Math.min(blockposition.getZ(), blockposition1.getZ()));
            BlockPos blockposition3 = new BlockPos(Math.max(blockposition.getX(), blockposition1.getX()), Math.max(blockposition.getY(), blockposition1.getY()), Math.max(blockposition.getZ(), blockposition1.getZ()));
            this.size = baseblockposition;
            try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(LOGGER);){
                for (BlockPos blockposition4 : BlockPos.betweenClosed(blockposition2, blockposition3)) {
                    StructureBlockInfo definedstructure_blockinfo;
                    BlockPos blockposition5 = blockposition4.subtract(blockposition2);
                    BlockState iblockdata = world.getBlockState(blockposition4);
                    Stream stream = list.stream();
                    Objects.requireNonNull(iblockdata);
                    if (stream.anyMatch(iblockdata::is)) continue;
                    BlockEntity tileentity = world.getBlockEntity(blockposition4);
                    if (tileentity != null) {
                        TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, world.registryAccess());
                        tileentity.saveWithId(tagvalueoutput);
                        definedstructure_blockinfo = new StructureBlockInfo(blockposition5, iblockdata, tagvalueoutput.buildResult());
                    } else {
                        definedstructure_blockinfo = new StructureBlockInfo(blockposition5, iblockdata, null);
                    }
                    StructureTemplate.addToLists(definedstructure_blockinfo, list1, list2, list3);
                }
                List<StructureBlockInfo> list4 = StructureTemplate.buildInfoList(list1, list2, list3);
                this.palettes.clear();
                this.palettes.add(new Palette(list4));
                if (flag) {
                    this.fillEntityList(world, blockposition2, blockposition3, problemreporter_j);
                } else {
                    this.entityInfoList.clear();
                }
            }
        }
    }

    private static void addToLists(StructureBlockInfo definedstructure_blockinfo, List<StructureBlockInfo> list, List<StructureBlockInfo> list1, List<StructureBlockInfo> list2) {
        if (definedstructure_blockinfo.nbt != null) {
            list1.add(definedstructure_blockinfo);
        } else if (!definedstructure_blockinfo.state.getBlock().hasDynamicShape() && definedstructure_blockinfo.state.isCollisionShapeFullBlock(EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
            list.add(definedstructure_blockinfo);
        } else {
            list2.add(definedstructure_blockinfo);
        }
    }

    private static List<StructureBlockInfo> buildInfoList(List<StructureBlockInfo> list, List<StructureBlockInfo> list1, List<StructureBlockInfo> list2) {
        Comparator<StructureBlockInfo> comparator = Comparator.comparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getY()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getX()).thenComparingInt(definedstructure_blockinfo -> definedstructure_blockinfo.pos.getZ());
        list.sort(comparator);
        list2.sort(comparator);
        list1.sort(comparator);
        ArrayList list3 = Lists.newArrayList();
        list3.addAll(list);
        list3.addAll(list2);
        list3.addAll(list1);
        return list3;
    }

    private void fillEntityList(Level world, BlockPos blockposition, BlockPos blockposition1, ProblemReporter problemreporter) {
        List<Entity> list = world.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks(blockposition, blockposition1), entity -> !(entity instanceof Player));
        this.entityInfoList.clear();
        for (Entity entity2 : list) {
            BlockPos blockposition2;
            Vec3 vec3d = new Vec3(entity2.getX() - (double)blockposition.getX(), entity2.getY() - (double)blockposition.getY(), entity2.getZ() - (double)blockposition.getZ());
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter.forChild(entity2.problemPath()), entity2.registryAccess());
            entity2.save(tagvalueoutput);
            if (entity2 instanceof Painting) {
                Painting entitypainting = (Painting)entity2;
                blockposition2 = entitypainting.getPos().subtract(blockposition);
            } else {
                blockposition2 = BlockPos.containing(vec3d);
            }
            this.entityInfoList.add(new StructureEntityInfo(vec3d, blockposition2, tagvalueoutput.buildResult().copy()));
        }
    }

    public List<StructureBlockInfo> filterBlocks(BlockPos blockposition, StructurePlaceSettings definedstructureinfo, Block block) {
        return this.filterBlocks(blockposition, definedstructureinfo, block, true);
    }

    public List<JigsawBlockInfo> getJigsaws(BlockPos blockposition, Rotation enumblockrotation) {
        if (this.palettes.isEmpty()) {
            return new ArrayList<JigsawBlockInfo>();
        }
        StructurePlaceSettings definedstructureinfo = new StructurePlaceSettings().setRotation(enumblockrotation);
        List<JigsawBlockInfo> list = definedstructureinfo.getRandomPalette(this.palettes, blockposition).jigsaws();
        ArrayList<JigsawBlockInfo> list1 = new ArrayList<JigsawBlockInfo>(list.size());
        for (JigsawBlockInfo definedstructure_a : list) {
            StructureBlockInfo definedstructure_blockinfo = definedstructure_a.info;
            list1.add(definedstructure_a.withInfo(new StructureBlockInfo(StructureTemplate.calculateRelativePosition(definedstructureinfo, definedstructure_blockinfo.pos()).offset(blockposition), definedstructure_blockinfo.state.rotate(definedstructureinfo.getRotation()), definedstructure_blockinfo.nbt)));
        }
        return list1;
    }

    public ObjectArrayList<StructureBlockInfo> filterBlocks(BlockPos blockposition, StructurePlaceSettings definedstructureinfo, Block block, boolean flag) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        BoundingBox structureboundingbox = definedstructureinfo.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return objectarraylist;
        }
        for (StructureBlockInfo definedstructure_blockinfo : definedstructureinfo.getRandomPalette(this.palettes, blockposition).blocks(block)) {
            BlockPos blockposition1;
            BlockPos blockPos = blockposition1 = flag ? StructureTemplate.calculateRelativePosition(definedstructureinfo, definedstructure_blockinfo.pos).offset(blockposition) : definedstructure_blockinfo.pos;
            if (structureboundingbox != null && !structureboundingbox.isInside(blockposition1)) continue;
            objectarraylist.add((Object)new StructureBlockInfo(blockposition1, definedstructure_blockinfo.state.rotate(definedstructureinfo.getRotation()), definedstructure_blockinfo.nbt));
        }
        return objectarraylist;
    }

    public BlockPos calculateConnectedPosition(StructurePlaceSettings definedstructureinfo, BlockPos blockposition, StructurePlaceSettings definedstructureinfo1, BlockPos blockposition1) {
        BlockPos blockposition2 = StructureTemplate.calculateRelativePosition(definedstructureinfo, blockposition);
        BlockPos blockposition3 = StructureTemplate.calculateRelativePosition(definedstructureinfo1, blockposition1);
        return blockposition2.subtract(blockposition3);
    }

    public static BlockPos calculateRelativePosition(StructurePlaceSettings definedstructureinfo, BlockPos blockposition) {
        return StructureTemplate.transform(blockposition, definedstructureinfo.getMirror(), definedstructureinfo.getRotation(), definedstructureinfo.getRotationPivot());
    }

    public boolean placeInWorld(ServerLevelAccessor worldaccess, BlockPos blockposition, BlockPos blockposition1, StructurePlaceSettings definedstructureinfo, RandomSource randomsource, int i) {
        List<StructureBlockInfo> list;
        if (this.palettes.isEmpty()) {
            return false;
        }
        ServerLevelAccessor wrappedAccess = worldaccess;
        CraftStructureTransformer structureTransformer = null;
        if (wrappedAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)wrappedAccess;
            worldaccess = transformerAccess.getHandle();
            structureTransformer = transformerAccess.getStructureTransformer();
            if (structureTransformer != null && !structureTransformer.canTransformBlocks()) {
                structureTransformer = null;
            }
        }
        if (!((list = definedstructureinfo.getRandomPalette(this.palettes, blockposition).blocks()).isEmpty() && (definedstructureinfo.isIgnoreEntities() || this.entityInfoList.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1)) {
            BoundingBox structureboundingbox = definedstructureinfo.getBoundingBox();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(definedstructureinfo.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(definedstructureinfo.shouldApplyWaterlogging() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MAX_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            int k1 = Integer.MIN_VALUE;
            List<StructureBlockInfo> list4 = StructureTemplate.processBlockInfos(worldaccess, blockposition, blockposition1, definedstructureinfo, list);
            try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(LOGGER);){
                for (StructureBlockInfo definedstructure_blockinfo : list4) {
                    BlockEntity tileentity;
                    BlockPos blockposition2 = definedstructure_blockinfo.pos;
                    if (structureboundingbox != null && !structureboundingbox.isInside(blockposition2)) continue;
                    FluidState fluid = definedstructureinfo.shouldApplyWaterlogging() ? worldaccess.getFluidState(blockposition2) : null;
                    BlockState iblockdata = definedstructure_blockinfo.state.mirror(definedstructureinfo.getMirror()).rotate(definedstructureinfo.getRotation());
                    if (definedstructure_blockinfo.nbt != null) {
                        worldaccess.setBlock(blockposition2, Blocks.BARRIER.defaultBlockState(), 820);
                    }
                    if (structureTransformer != null) {
                        CompoundTag compoundTag;
                        CraftBlockState craftBlockState = (CraftBlockState)CraftBlockStates.getBlockState((LevelReader)worldaccess, blockposition2, iblockdata, null);
                        if (definedstructure_blockinfo.nbt != null && craftBlockState instanceof CraftBlockEntityState) {
                            CraftBlockEntityState entityState = (CraftBlockEntityState)craftBlockState;
                            entityState.loadData(definedstructure_blockinfo.nbt);
                            if (craftBlockState instanceof CraftLootable) {
                                CraftLootable craftLootable = (CraftLootable)craftBlockState;
                                craftLootable.setSeed(randomsource.nextLong());
                            }
                        }
                        craftBlockState = structureTransformer.transformCraftState(craftBlockState);
                        iblockdata = craftBlockState.getHandle();
                        if (craftBlockState instanceof CraftBlockEntityState) {
                            CraftBlockEntityState craftBlockEntityState = (CraftBlockEntityState)craftBlockState;
                            compoundTag = craftBlockEntityState.getSnapshotNBT();
                        } else {
                            compoundTag = null;
                        }
                        definedstructure_blockinfo = new StructureBlockInfo(blockposition2, iblockdata, compoundTag);
                    }
                    if (!worldaccess.setBlock(blockposition2, iblockdata, i)) continue;
                    j = Math.min(j, blockposition2.getX());
                    k = Math.min(k, blockposition2.getY());
                    l = Math.min(l, blockposition2.getZ());
                    i1 = Math.max(i1, blockposition2.getX());
                    j1 = Math.max(j1, blockposition2.getY());
                    k1 = Math.max(k1, blockposition2.getZ());
                    list3.add(Pair.of((Object)blockposition2, (Object)definedstructure_blockinfo.nbt));
                    if (definedstructure_blockinfo.nbt != null && (tileentity = worldaccess.getBlockEntity(blockposition2)) != null) {
                        if (tileentity instanceof RandomizableContainer) {
                            definedstructure_blockinfo.nbt.putLong("LootTableSeed", randomsource.nextLong());
                        }
                        tileentity.loadWithComponents(TagValueInput.create(problemreporter_j.forChild(tileentity.problemPath()), (HolderLookup.Provider)worldaccess.registryAccess(), definedstructure_blockinfo.nbt));
                    }
                    if (fluid == null) continue;
                    if (iblockdata.getFluidState().isSource()) {
                        list2.add(blockposition2);
                        continue;
                    }
                    if (!(iblockdata.getBlock() instanceof LiquidBlockContainer)) continue;
                    ((LiquidBlockContainer)((Object)iblockdata.getBlock())).placeLiquid(worldaccess, blockposition2, iblockdata, fluid);
                    if (fluid.isSource()) continue;
                    list1.add(blockposition2);
                }
                boolean flag = true;
                Direction[] aenumdirection = new Direction[]{Direction.UP, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
                while (flag && !list1.isEmpty()) {
                    flag = false;
                    Iterator iterator = list1.iterator();
                    while (iterator.hasNext()) {
                        BlockState iblockdata1;
                        Object block;
                        BlockPos blockposition3 = (BlockPos)iterator.next();
                        FluidState fluid1 = worldaccess.getFluidState(blockposition3);
                        for (int l1 = 0; l1 < aenumdirection.length && !fluid1.isSource(); ++l1) {
                            BlockPos blockposition4 = blockposition3.relative(aenumdirection[l1]);
                            FluidState fluid2 = worldaccess.getFluidState(blockposition4);
                            if (!fluid2.isSource() || list2.contains(blockposition4)) continue;
                            fluid1 = fluid2;
                        }
                        if (!fluid1.isSource() || !((block = (iblockdata1 = worldaccess.getBlockState(blockposition3)).getBlock()) instanceof LiquidBlockContainer)) continue;
                        ((LiquidBlockContainer)block).placeLiquid(worldaccess, blockposition3, iblockdata1, fluid1);
                        flag = true;
                        iterator.remove();
                    }
                }
                if (j <= i1) {
                    if (!definedstructureinfo.getKnownShape()) {
                        BitSetDiscreteVoxelShape voxelshapediscrete = new BitSetDiscreteVoxelShape(i1 - j + 1, j1 - k + 1, k1 - l + 1);
                        int i2 = j;
                        int j2 = k;
                        int k2 = l;
                        for (Pair pair : list3) {
                            BlockPos blockposition5 = (BlockPos)pair.getFirst();
                            ((DiscreteVoxelShape)voxelshapediscrete).fill(blockposition5.getX() - i2, blockposition5.getY() - j2, blockposition5.getZ() - k2);
                        }
                        StructureTemplate.updateShapeAtEdge(worldaccess, i, voxelshapediscrete, i2, j2, k2);
                    }
                    for (Pair pair1 : list3) {
                        BlockEntity tileentity1;
                        BlockPos blockposition6 = (BlockPos)pair1.getFirst();
                        if (!definedstructureinfo.getKnownShape()) {
                            BlockState iblockdata3;
                            BlockState iblockdata2 = worldaccess.getBlockState(blockposition6);
                            if (iblockdata2 != (iblockdata3 = Block.updateFromNeighbourShapes(iblockdata2, worldaccess, blockposition6))) {
                                worldaccess.setBlock(blockposition6, iblockdata3, i & 0xFFFFFFFE | 0x10);
                            }
                            worldaccess.updateNeighborsAt(blockposition6, iblockdata3.getBlock());
                        }
                        if (pair1.getSecond() == null || (tileentity1 = worldaccess.getBlockEntity(blockposition6)) == null) continue;
                        tileentity1.setChanged();
                    }
                }
                if (!definedstructureinfo.isIgnoreEntities()) {
                    this.placeEntities(wrappedAccess, blockposition, definedstructureinfo.getMirror(), definedstructureinfo.getRotation(), definedstructureinfo.getRotationPivot(), structureboundingbox, definedstructureinfo.shouldFinalizeEntities(), problemreporter_j);
                }
            }
            return true;
        }
        return false;
    }

    public static void updateShapeAtEdge(LevelAccessor generatoraccess, int i, DiscreteVoxelShape voxelshapediscrete, BlockPos blockposition) {
        StructureTemplate.updateShapeAtEdge(generatoraccess, i, voxelshapediscrete, blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    public static void updateShapeAtEdge(LevelAccessor generatoraccess, int i, DiscreteVoxelShape voxelshapediscrete, int j, int k, int l) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockposition_mutableblockposition1 = new BlockPos.MutableBlockPos();
        voxelshapediscrete.forAllFaces((enumdirection, i1, j1, k1) -> {
            BlockState iblockdata3;
            blockposition_mutableblockposition.set(j + i1, k + j1, l + k1);
            blockposition_mutableblockposition1.setWithOffset((Vec3i)blockposition_mutableblockposition, enumdirection);
            BlockState iblockdata = generatoraccess.getBlockState(blockposition_mutableblockposition);
            BlockState iblockdata1 = generatoraccess.getBlockState(blockposition_mutableblockposition1);
            BlockState iblockdata2 = iblockdata.updateShape(generatoraccess, generatoraccess, blockposition_mutableblockposition, enumdirection, blockposition_mutableblockposition1, iblockdata1, generatoraccess.getRandom());
            if (iblockdata != iblockdata2) {
                generatoraccess.setBlock(blockposition_mutableblockposition, iblockdata2, i & 0xFFFFFFFE);
            }
            if (iblockdata1 != (iblockdata3 = iblockdata1.updateShape(generatoraccess, generatoraccess, blockposition_mutableblockposition1, enumdirection.getOpposite(), blockposition_mutableblockposition, iblockdata2, generatoraccess.getRandom()))) {
                generatoraccess.setBlock(blockposition_mutableblockposition1, iblockdata3, i & 0xFFFFFFFE);
            }
        });
    }

    public static List<StructureBlockInfo> processBlockInfos(ServerLevelAccessor worldaccess, BlockPos blockposition, BlockPos blockposition1, StructurePlaceSettings definedstructureinfo, List<StructureBlockInfo> list) {
        ArrayList<StructureBlockInfo> list1 = new ArrayList<StructureBlockInfo>();
        List<StructureBlockInfo> list2 = new ArrayList<StructureBlockInfo>();
        for (StructureBlockInfo definedstructure_blockinfo : list) {
            BlockPos blockposition2 = StructureTemplate.calculateRelativePosition(definedstructureinfo, definedstructure_blockinfo.pos).offset(blockposition);
            StructureBlockInfo definedstructure_blockinfo1 = new StructureBlockInfo(blockposition2, definedstructure_blockinfo.state, definedstructure_blockinfo.nbt != null ? definedstructure_blockinfo.nbt.copy() : null);
            Iterator<StructureProcessor> iterator = definedstructureinfo.getProcessors().iterator();
            while (definedstructure_blockinfo1 != null && iterator.hasNext()) {
                definedstructure_blockinfo1 = iterator.next().processBlock(worldaccess, blockposition, blockposition1, definedstructure_blockinfo, definedstructure_blockinfo1, definedstructureinfo);
            }
            if (definedstructure_blockinfo1 == null) continue;
            list2.add(definedstructure_blockinfo1);
            list1.add(definedstructure_blockinfo);
        }
        for (StructureProcessor definedstructureprocessor : definedstructureinfo.getProcessors()) {
            list2 = definedstructureprocessor.finalizeProcessing(worldaccess, blockposition, blockposition1, list1, list2, definedstructureinfo);
        }
        return list2;
    }

    private void placeEntities(ServerLevelAccessor worldaccess, BlockPos blockposition, Mirror enumblockmirror, Rotation enumblockrotation, BlockPos blockposition1, @Nullable BoundingBox structureboundingbox, boolean flag, ProblemReporter problemreporter) {
        for (StructureEntityInfo definedstructure_entityinfo : this.entityInfoList) {
            BlockPos blockposition2 = StructureTemplate.transform(definedstructure_entityinfo.blockPos, enumblockmirror, enumblockrotation, blockposition1).offset(blockposition);
            if (structureboundingbox != null && !structureboundingbox.isInside(blockposition2)) continue;
            CompoundTag nbttagcompound = definedstructure_entityinfo.nbt.copy();
            Vec3 vec3d = StructureTemplate.transform(definedstructure_entityinfo.pos, enumblockmirror, enumblockrotation, blockposition1);
            Vec3 vec3d1 = vec3d.add(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            ListTag nbttaglist = new ListTag();
            nbttaglist.add(DoubleTag.valueOf(vec3d1.x));
            nbttaglist.add(DoubleTag.valueOf(vec3d1.y));
            nbttaglist.add(DoubleTag.valueOf(vec3d1.z));
            nbttagcompound.put("Pos", nbttaglist);
            nbttagcompound.remove("UUID");
            StructureTemplate.createEntityIgnoreException(problemreporter, worldaccess, nbttagcompound).ifPresent(entity -> {
                float f = entity.rotate(enumblockrotation);
                entity.snapTo(vec3d1.x, vec3d1.y, vec3d1.z, f += entity.mirror(enumblockmirror) - entity.getYRot(), entity.getXRot());
                if (flag && entity instanceof Mob) {
                    ((Mob)entity).finalizeSpawn(worldaccess, worldaccess.getCurrentDifficultyAt(BlockPos.containing(vec3d1)), EntitySpawnReason.STRUCTURE, null);
                }
                worldaccess.addFreshEntityWithPassengers((Entity)entity);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(ProblemReporter problemreporter, ServerLevelAccessor worldaccess, CompoundTag nbttagcompound) {
        return EntityType.create(TagValueInput.create(problemreporter, (HolderLookup.Provider)worldaccess.registryAccess(), nbttagcompound), worldaccess.getLevel(), EntitySpawnReason.STRUCTURE);
    }

    public Vec3i getSize(Rotation enumblockrotation) {
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new Vec3i(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPos transform(BlockPos blockposition, Mirror enumblockmirror, Rotation enumblockrotation, BlockPos blockposition1) {
        int i = blockposition.getX();
        int j = blockposition.getY();
        int k = blockposition.getZ();
        boolean flag = true;
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = blockposition1.getX();
        int i1 = blockposition1.getZ();
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(l - i1 + k, j, l + i1 - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(l + i1 - k, j, i1 - l + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(l + l - i, j, i1 + i1 - k);
            }
        }
        return flag ? new BlockPos(i, j, k) : blockposition;
    }

    public static Vec3 transform(Vec3 vec3d, Mirror enumblockmirror, Rotation enumblockrotation, BlockPos blockposition) {
        double d0 = vec3d.x;
        double d1 = vec3d.y;
        double d2 = vec3d.z;
        boolean flag = true;
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i = blockposition.getX();
        int j = blockposition.getZ();
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3((double)(i - j) + d2, d1, (double)(i + j + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3((double)(i + j + 1) - d2, d1, (double)(j - i) + d0);
            }
            case CLOCKWISE_180: {
                return new Vec3((double)(i + i + 1) - d0, d1, (double)(j + j + 1) - d2);
            }
        }
        return flag ? new Vec3(d0, d1, d2) : vec3d;
    }

    public BlockPos getZeroPositionWithTransform(BlockPos blockposition, Mirror enumblockmirror, Rotation enumblockrotation) {
        return StructureTemplate.getZeroPositionWithTransform(blockposition, enumblockmirror, enumblockrotation, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPos getZeroPositionWithTransform(BlockPos blockposition, Mirror enumblockmirror, Rotation enumblockrotation, int i, int j) {
        int k = enumblockmirror == Mirror.FRONT_BACK ? --i : 0;
        int l = enumblockmirror == Mirror.LEFT_RIGHT ? --j : 0;
        BlockPos blockposition1 = blockposition;
        switch (enumblockrotation) {
            case COUNTERCLOCKWISE_90: {
                blockposition1 = blockposition.offset(l, 0, i - k);
                break;
            }
            case CLOCKWISE_90: {
                blockposition1 = blockposition.offset(j - l, 0, k);
                break;
            }
            case CLOCKWISE_180: {
                blockposition1 = blockposition.offset(i - k, 0, j - l);
                break;
            }
            case NONE: {
                blockposition1 = blockposition.offset(k, 0, l);
            }
        }
        return blockposition1;
    }

    public BoundingBox getBoundingBox(StructurePlaceSettings definedstructureinfo, BlockPos blockposition) {
        return this.getBoundingBox(blockposition, definedstructureinfo.getRotation(), definedstructureinfo.getRotationPivot(), definedstructureinfo.getMirror());
    }

    public BoundingBox getBoundingBox(BlockPos blockposition, Rotation enumblockrotation, BlockPos blockposition1, Mirror enumblockmirror) {
        return StructureTemplate.getBoundingBox(blockposition, enumblockrotation, blockposition1, enumblockmirror, this.size);
    }

    @VisibleForTesting
    protected static BoundingBox getBoundingBox(BlockPos blockposition, Rotation enumblockrotation, BlockPos blockposition1, Mirror enumblockmirror, Vec3i baseblockposition) {
        Vec3i baseblockposition1 = baseblockposition.offset(-1, -1, -1);
        BlockPos blockposition2 = StructureTemplate.transform(BlockPos.ZERO, enumblockmirror, enumblockrotation, blockposition1);
        BlockPos blockposition3 = StructureTemplate.transform(BlockPos.ZERO.offset(baseblockposition1), enumblockmirror, enumblockrotation, blockposition1);
        return BoundingBox.fromCorners(blockposition2, blockposition3).move(blockposition);
    }

    public CompoundTag save(CompoundTag nbttagcompound) {
        if (this.palettes.isEmpty()) {
            nbttagcompound.put(BLOCKS_TAG, new ListTag());
            nbttagcompound.put(PALETTE_TAG, new ListTag());
        } else {
            ArrayList list = Lists.newArrayList();
            SimplePalette definedstructure_c = new SimplePalette();
            list.add(definedstructure_c);
            for (int i = 1; i < this.palettes.size(); ++i) {
                list.add(new SimplePalette());
            }
            ListTag nbttaglist = new ListTag();
            List<StructureBlockInfo> list1 = this.palettes.get(0).blocks();
            for (int j = 0; j < list1.size(); ++j) {
                StructureBlockInfo definedstructure_blockinfo = list1.get(j);
                CompoundTag nbttagcompound1 = new CompoundTag();
                nbttagcompound1.put("pos", this.newIntegerList(definedstructure_blockinfo.pos.getX(), definedstructure_blockinfo.pos.getY(), definedstructure_blockinfo.pos.getZ()));
                int k = definedstructure_c.idFor(definedstructure_blockinfo.state);
                nbttagcompound1.putInt(BLOCK_TAG_STATE, k);
                if (definedstructure_blockinfo.nbt != null) {
                    nbttagcompound1.put("nbt", definedstructure_blockinfo.nbt);
                }
                nbttaglist.add(nbttagcompound1);
                for (int l = 1; l < this.palettes.size(); ++l) {
                    SimplePalette definedstructure_c1 = (SimplePalette)list.get(l);
                    definedstructure_c1.addMapping(this.palettes.get((int)l).blocks().get((int)j).state, k);
                }
            }
            nbttagcompound.put(BLOCKS_TAG, nbttaglist);
            if (list.size() == 1) {
                ListTag nbttaglist1 = new ListTag();
                for (BlockState iblockdata : definedstructure_c) {
                    nbttaglist1.add(NbtUtils.writeBlockState(iblockdata));
                }
                nbttagcompound.put(PALETTE_TAG, nbttaglist1);
            } else {
                ListTag nbttaglist2 = new ListTag();
                for (SimplePalette definedstructure_c2 : list) {
                    ListTag nbttaglist3 = new ListTag();
                    for (BlockState iblockdata1 : definedstructure_c2) {
                        nbttaglist3.add(NbtUtils.writeBlockState(iblockdata1));
                    }
                    nbttaglist2.add(nbttaglist3);
                }
                nbttagcompound.put(PALETTE_LIST_TAG, nbttaglist2);
            }
        }
        ListTag nbttaglist4 = new ListTag();
        for (StructureEntityInfo definedstructure_entityinfo : this.entityInfoList) {
            CompoundTag nbttagcompound2 = new CompoundTag();
            nbttagcompound2.put("pos", this.newDoubleList(definedstructure_entityinfo.pos.x, definedstructure_entityinfo.pos.y, definedstructure_entityinfo.pos.z));
            nbttagcompound2.put(ENTITY_TAG_BLOCKPOS, this.newIntegerList(definedstructure_entityinfo.blockPos.getX(), definedstructure_entityinfo.blockPos.getY(), definedstructure_entityinfo.blockPos.getZ()));
            if (definedstructure_entityinfo.nbt != null) {
                nbttagcompound2.put("nbt", definedstructure_entityinfo.nbt);
            }
            nbttaglist4.add(nbttagcompound2);
        }
        nbttagcompound.put(ENTITIES_TAG, nbttaglist4);
        nbttagcompound.put(SIZE_TAG, this.newIntegerList(this.size.getX(), this.size.getY(), this.size.getZ()));
        if (!this.persistentDataContainer.isEmpty()) {
            nbttagcompound.put("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return NbtUtils.addCurrentDataVersion(nbttagcompound);
    }

    public void load(HolderGetter<Block> holdergetter, CompoundTag nbttagcompound) {
        this.palettes.clear();
        this.entityInfoList.clear();
        ListTag nbttaglist = nbttagcompound.getListOrEmpty(SIZE_TAG);
        this.size = new Vec3i(nbttaglist.getIntOr(0, 0), nbttaglist.getIntOr(1, 0), nbttaglist.getIntOr(2, 0));
        ListTag nbttaglist1 = nbttagcompound.getListOrEmpty(BLOCKS_TAG);
        Optional<ListTag> optional = nbttagcompound.getList(PALETTE_LIST_TAG);
        if (optional.isPresent()) {
            for (int i = 0; i < optional.get().size(); ++i) {
                this.loadPalette(holdergetter, optional.get().getListOrEmpty(i), nbttaglist1);
            }
        } else {
            this.loadPalette(holdergetter, nbttagcompound.getListOrEmpty(PALETTE_TAG), nbttaglist1);
        }
        nbttagcompound.getListOrEmpty(ENTITIES_TAG).compoundStream().forEach(nbttagcompound1 -> {
            ListTag nbttaglist2 = nbttagcompound1.getListOrEmpty("pos");
            Vec3 vec3d = new Vec3(nbttaglist2.getDoubleOr(0, 0.0), nbttaglist2.getDoubleOr(1, 0.0), nbttaglist2.getDoubleOr(2, 0.0));
            ListTag nbttaglist3 = nbttagcompound1.getListOrEmpty(ENTITY_TAG_BLOCKPOS);
            BlockPos blockposition = new BlockPos(nbttaglist3.getIntOr(0, 0), nbttaglist3.getIntOr(1, 0), nbttaglist3.getIntOr(2, 0));
            nbttagcompound1.getCompound("nbt").ifPresent(nbttagcompound2 -> this.entityInfoList.add(new StructureEntityInfo(vec3d, blockposition, (CompoundTag)nbttagcompound2)));
        });
        Tag base = nbttagcompound.get("BukkitValues");
        if (base instanceof CompoundTag) {
            this.persistentDataContainer.putAll((CompoundTag)base);
        }
    }

    private void loadPalette(HolderGetter<Block> holdergetter, ListTag nbttaglist, ListTag nbttaglist1) {
        SimplePalette definedstructure_c = new SimplePalette();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            definedstructure_c.addMapping(NbtUtils.readBlockState(holdergetter, nbttaglist.getCompoundOrEmpty(i)), i);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        nbttaglist1.compoundStream().forEach(nbttagcompound -> {
            ListTag nbttaglist2 = nbttagcompound.getListOrEmpty("pos");
            BlockPos blockposition = new BlockPos(nbttaglist2.getIntOr(0, 0), nbttaglist2.getIntOr(1, 0), nbttaglist2.getIntOr(2, 0));
            BlockState iblockdata = definedstructure_c.stateFor(nbttagcompound.getIntOr(BLOCK_TAG_STATE, 0));
            CompoundTag nbttagcompound1 = nbttagcompound.getCompound("nbt").orElse(null);
            StructureBlockInfo definedstructure_blockinfo = new StructureBlockInfo(blockposition, iblockdata, nbttagcompound1);
            StructureTemplate.addToLists(definedstructure_blockinfo, list, list1, list2);
        });
        List<StructureBlockInfo> list3 = StructureTemplate.buildInfoList(list, list1, list2);
        this.palettes.add(new Palette(list3));
    }

    private ListTag newIntegerList(int ... aint) {
        ListTag nbttaglist = new ListTag();
        for (int i : aint) {
            nbttaglist.add(IntTag.valueOf(i));
        }
        return nbttaglist;
    }

    private ListTag newDoubleList(double ... adouble) {
        ListTag nbttaglist = new ListTag();
        for (double d0 : adouble) {
            nbttaglist.add(DoubleTag.valueOf(d0));
        }
        return nbttaglist;
    }

    public static JigsawBlockEntity.JointType getJointType(CompoundTag nbttagcompound, BlockState iblockdata) {
        return nbttagcompound.read("joint", JigsawBlockEntity.JointType.CODEC).orElseGet(() -> StructureTemplate.getDefaultJointType(iblockdata));
    }

    public static JigsawBlockEntity.JointType getDefaultJointType(BlockState iblockdata) {
        return JigsawBlock.getFrontFacing(iblockdata).getAxis().isHorizontal() ? JigsawBlockEntity.JointType.ALIGNED : JigsawBlockEntity.JointType.ROLLABLE;
    }

    public record StructureBlockInfo(BlockPos pos, BlockState state, @Nullable CompoundTag nbt) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }
    }

    public static final class Palette {
        private final List<StructureBlockInfo> blocks;
        private final Map<Block, List<StructureBlockInfo>> cache = Maps.newHashMap();
        @Nullable
        private List<JigsawBlockInfo> cachedJigsaws;

        Palette(List<StructureBlockInfo> list) {
            this.blocks = list;
        }

        public List<JigsawBlockInfo> jigsaws() {
            if (this.cachedJigsaws == null) {
                this.cachedJigsaws = this.blocks(Blocks.JIGSAW).stream().map(JigsawBlockInfo::of).toList();
            }
            return this.cachedJigsaws;
        }

        public List<StructureBlockInfo> blocks() {
            return this.blocks;
        }

        public List<StructureBlockInfo> blocks(Block block) {
            return this.cache.computeIfAbsent(block, block1 -> this.blocks.stream().filter(definedstructure_blockinfo -> definedstructure_blockinfo.state.is((Block)block1)).collect(Collectors.toList()));
        }
    }

    public static class StructureEntityInfo {
        public final Vec3 pos;
        public final BlockPos blockPos;
        public final CompoundTag nbt;

        public StructureEntityInfo(Vec3 vec3d, BlockPos blockposition, CompoundTag nbttagcompound) {
            this.pos = vec3d;
            this.blockPos = blockposition;
            this.nbt = nbttagcompound;
        }
    }

    public record JigsawBlockInfo(StructureBlockInfo info, JigsawBlockEntity.JointType jointType, ResourceLocation name, ResourceKey<StructureTemplatePool> pool, ResourceLocation target, int placementPriority, int selectionPriority) {
        public static JigsawBlockInfo of(StructureBlockInfo definedstructure_blockinfo) {
            CompoundTag nbttagcompound = Objects.requireNonNull(definedstructure_blockinfo.nbt(), () -> String.valueOf(definedstructure_blockinfo) + " nbt was null");
            return new JigsawBlockInfo(definedstructure_blockinfo, StructureTemplate.getJointType(nbttagcompound, definedstructure_blockinfo.state()), nbttagcompound.read("name", ResourceLocation.CODEC).orElse(JigsawBlockEntity.EMPTY_ID), nbttagcompound.read("pool", JigsawBlockEntity.POOL_CODEC).orElse(Pools.EMPTY), nbttagcompound.read("target", ResourceLocation.CODEC).orElse(JigsawBlockEntity.EMPTY_ID), nbttagcompound.getIntOr("placement_priority", 0), nbttagcompound.getIntOr("selection_priority", 0));
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<JigsawBlockInfo | %s | %s | name: %s | pool: %s | target: %s | placement: %d | selection: %d | %s>", this.info.pos, this.info.state, this.name, this.pool.location(), this.target, this.placementPriority, this.selectionPriority, this.info.nbt);
        }

        public JigsawBlockInfo withInfo(StructureBlockInfo definedstructure_blockinfo) {
            return new JigsawBlockInfo(definedstructure_blockinfo, this.jointType, this.name, this.pool, this.target, this.placementPriority, this.selectionPriority);
        }
    }

    private static class SimplePalette
    implements Iterable<BlockState> {
        public static final BlockState DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final IdMapper<BlockState> ids = new IdMapper(16);
        private int lastId;

        SimplePalette() {
        }

        public int idFor(BlockState iblockdata) {
            int i = this.ids.getId(iblockdata);
            if (i == -1) {
                i = this.lastId++;
                this.ids.addMapping(iblockdata, i);
            }
            return i;
        }

        @Nullable
        public BlockState stateFor(int i) {
            BlockState iblockdata = this.ids.byId(i);
            return iblockdata == null ? DEFAULT_BLOCK_STATE : iblockdata;
        }

        @Override
        public Iterator<BlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(BlockState iblockdata, int i) {
            this.ids.addMapping(iblockdata, i);
        }
    }
}

