/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class StructureTemplateManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String STRUCTURE_RESOURCE_DIRECTORY_NAME = "structure";
    private static final String STRUCTURE_GENERATED_DIRECTORY_NAME = "structures";
    private static final String STRUCTURE_FILE_EXTENSION = ".nbt";
    private static final String STRUCTURE_TEXT_FILE_EXTENSION = ".snbt";
    public final Map<ResourceLocation, Optional<StructureTemplate>> structureRepository = Maps.newConcurrentMap();
    private final DataFixer fixerUpper;
    private ResourceManager resourceManager;
    private final Path generatedDir;
    private final List<Source> sources;
    private final HolderGetter<Block> blockLookup;
    private static final FileToIdConverter RESOURCE_LISTER = new FileToIdConverter("structure", ".nbt");

    public StructureTemplateManager(ResourceManager var0, LevelStorageSource.LevelStorageAccess var1, DataFixer var2, HolderGetter<Block> var3) {
        this.resourceManager = var0;
        this.fixerUpper = var2;
        this.generatedDir = var1.getLevelPath(LevelResource.GENERATED_DIR).normalize();
        this.blockLookup = var3;
        ImmutableList.Builder var4 = ImmutableList.builder();
        var4.add((Object)new Source(this::loadFromGenerated, this::listGenerated));
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            var4.add((Object)new Source(this::loadFromTestStructures, this::listTestStructures));
        }
        var4.add((Object)new Source(this::loadFromResource, this::listResources));
        this.sources = var4.build();
    }

    public StructureTemplate getOrCreate(ResourceLocation var0) {
        Optional<StructureTemplate> var1 = this.get(var0);
        if (var1.isPresent()) {
            return var1.get();
        }
        StructureTemplate var2 = new StructureTemplate();
        this.structureRepository.put(var0, Optional.of(var2));
        return var2;
    }

    public Optional<StructureTemplate> get(ResourceLocation var0) {
        return this.structureRepository.computeIfAbsent(var0, this::tryLoad);
    }

    public Stream<ResourceLocation> listTemplates() {
        return this.sources.stream().flatMap(var0 -> var0.lister().get()).distinct();
    }

    private Optional<StructureTemplate> tryLoad(ResourceLocation var0) {
        for (Source var2 : this.sources) {
            try {
                Optional<StructureTemplate> var3 = var2.loader().apply(var0);
                if (!var3.isPresent()) continue;
                return var3;
            }
            catch (Exception exception) {
            }
        }
        return Optional.empty();
    }

    public void onResourceManagerReload(ResourceManager var0) {
        this.resourceManager = var0;
        this.structureRepository.clear();
    }

    public Optional<StructureTemplate> loadFromResource(ResourceLocation var0) {
        ResourceLocation var12 = RESOURCE_LISTER.idToFile(var0);
        return this.load(() -> this.resourceManager.open(var12), var1 -> LOGGER.error("Couldn't load structure {}", (Object)var0, var1));
    }

    private Stream<ResourceLocation> listResources() {
        return RESOURCE_LISTER.listMatchingResources(this.resourceManager).keySet().stream().map(RESOURCE_LISTER::fileToId);
    }

    private Optional<StructureTemplate> loadFromTestStructures(ResourceLocation var0) {
        return this.loadFromSnbt(var0, StructureUtils.testStructuresDir);
    }

    private Stream<ResourceLocation> listTestStructures() {
        if (!Files.isDirectory(StructureUtils.testStructuresDir, new LinkOption[0])) {
            return Stream.empty();
        }
        ArrayList var0 = new ArrayList();
        this.listFolderContents(StructureUtils.testStructuresDir, "minecraft", STRUCTURE_TEXT_FILE_EXTENSION, var0::add);
        return var0.stream();
    }

    public Optional<StructureTemplate> loadFromGenerated(ResourceLocation var0) {
        if (!Files.isDirectory(this.generatedDir, new LinkOption[0])) {
            return Optional.empty();
        }
        Path var12 = this.createAndValidatePathToGeneratedStructure(var0, STRUCTURE_FILE_EXTENSION);
        return this.load(() -> new FileInputStream(var12.toFile()), var1 -> LOGGER.error("Couldn't load structure from {}", (Object)var12, var1));
    }

    private Stream<ResourceLocation> listGenerated() {
        if (!Files.isDirectory(this.generatedDir, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            ArrayList var02 = new ArrayList();
            try (DirectoryStream<Path> var1 = Files.newDirectoryStream(this.generatedDir, var0 -> Files.isDirectory(var0, new LinkOption[0]));){
                for (Path var3 : var1) {
                    String var4 = var3.getFileName().toString();
                    Path var5 = var3.resolve(STRUCTURE_GENERATED_DIRECTORY_NAME);
                    this.listFolderContents(var5, var4, STRUCTURE_FILE_EXTENSION, var02::add);
                }
            }
            return var02.stream();
        }
        catch (IOException var03) {
            return Stream.empty();
        }
    }

    private void listFolderContents(Path var0, String var12, String var22, Consumer<ResourceLocation> var3) {
        int var42 = var22.length();
        Function<String, String> var5 = var1 -> var1.substring(0, var1.length() - var42);
        try (Stream<Path> var6 = Files.find(var0, Integer.MAX_VALUE, (var1, var2) -> var2.isRegularFile() && var1.toString().endsWith(var22), new FileVisitOption[0]);){
            var6.forEach(var4 -> {
                try {
                    var3.accept(ResourceLocation.fromNamespaceAndPath(var12, (String)var5.apply(this.relativize(var0, (Path)var4))));
                }
                catch (ResourceLocationException var5) {
                    LOGGER.error("Invalid location while listing folder {} contents", (Object)var0, (Object)var5);
                }
            });
        }
        catch (IOException var62) {
            LOGGER.error("Failed to list folder {} contents", (Object)var0, (Object)var62);
        }
    }

    private String relativize(Path var0, Path var1) {
        return var0.relativize(var1).toString().replace(File.separator, "/");
    }

    private Optional<StructureTemplate> loadFromSnbt(ResourceLocation var0, Path var1) {
        Optional<StructureTemplate> optional;
        block10: {
            if (!Files.isDirectory(var1, new LinkOption[0])) {
                return Optional.empty();
            }
            Path var2 = FileUtil.createPathToResource(var1, var0.getPath(), STRUCTURE_TEXT_FILE_EXTENSION);
            BufferedReader var3 = Files.newBufferedReader(var2);
            try {
                String var4 = IOUtils.toString((Reader)var3);
                optional = Optional.of(this.readStructure(NbtUtils.snbtToStructure(var4)));
                if (var3 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (var3 != null) {
                        try {
                            var3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException var32) {
                    return Optional.empty();
                }
                catch (CommandSyntaxException | IOException var33) {
                    LOGGER.error("Couldn't load structure from {}", (Object)var2, (Object)var33);
                    return Optional.empty();
                }
            }
            var3.close();
        }
        return optional;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<StructureTemplate> load(InputStreamOpener var0, Consumer<Throwable> var1) {
        try (InputStream var2 = var0.open();){
            Optional<StructureTemplate> optional;
            try (FastBufferedInputStream var3 = new FastBufferedInputStream(var2);){
                optional = Optional.of(this.readStructure(var3));
            }
            return optional;
        }
        catch (FileNotFoundException var22) {
            return Optional.empty();
        }
        catch (Throwable var23) {
            var1.accept(var23);
            return Optional.empty();
        }
    }

    public StructureTemplate readStructure(InputStream var0) throws IOException {
        CompoundTag var1 = NbtIo.readCompressed(var0, NbtAccounter.unlimitedHeap());
        return this.readStructure(var1);
    }

    public StructureTemplate readStructure(CompoundTag var0) {
        StructureTemplate var1 = new StructureTemplate();
        int var2 = NbtUtils.getDataVersion(var0, 500);
        var1.load(this.blockLookup, DataFixTypes.STRUCTURE.updateToCurrentVersion(this.fixerUpper, var0, var2));
        return var1;
    }

    public boolean save(ResourceLocation var0) {
        Optional<StructureTemplate> var1 = this.structureRepository.get(var0);
        if (var1.isEmpty()) {
            return false;
        }
        StructureTemplate var2 = var1.get();
        Path var3 = this.createAndValidatePathToGeneratedStructure(var0, STRUCTURE_FILE_EXTENSION);
        Path var4 = var3.getParent();
        if (var4 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(var4, new LinkOption[0]) ? var4.toRealPath(new LinkOption[0]) : var4, new FileAttribute[0]);
        }
        catch (IOException var5) {
            LOGGER.error("Failed to create parent directory: {}", (Object)var4);
            return false;
        }
        CompoundTag var5 = var2.save(new CompoundTag());
        try (FileOutputStream var6 = new FileOutputStream(var3.toFile());){
            NbtIo.writeCompressed(var5, var6);
        }
        catch (Throwable var62) {
            return false;
        }
        return true;
    }

    public Path createAndValidatePathToGeneratedStructure(ResourceLocation var0, String var1) {
        if (var0.getPath().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + String.valueOf(var0));
        }
        try {
            Path var2 = this.generatedDir.resolve(var0.getNamespace());
            Path var3 = var2.resolve(STRUCTURE_GENERATED_DIRECTORY_NAME);
            Path var4 = FileUtil.createPathToResource(var3, var0.getPath(), var1);
            if (!(var4.startsWith(this.generatedDir) && FileUtil.isPathNormalized(var4) && FileUtil.isPathPortable(var4))) {
                throw new ResourceLocationException("Invalid resource path: " + String.valueOf(var4));
            }
            return var4;
        }
        catch (InvalidPathException var2) {
            throw new ResourceLocationException("Invalid resource path: " + String.valueOf(var0), var2);
        }
    }

    public void remove(ResourceLocation var0) {
        this.structureRepository.remove(var0);
    }

    record Source(Function<ResourceLocation, Optional<StructureTemplate>> loader, Supplier<Stream<ResourceLocation>> lister) {
    }

    @FunctionalInterface
    static interface InputStreamOpener {
        public InputStream open() throws IOException;
    }
}

