/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;

public class PerlinNoise {
    private static final int ROUND_OFF = 0x2000000;
    private final ImprovedNoise[] noiseLevels;
    private final int firstOctave;
    private final DoubleList amplitudes;
    private final double lowestFreqValueFactor;
    private final double lowestFreqInputFactor;
    private final double maxValue;

    @Deprecated
    public static PerlinNoise createLegacyForBlendedNoise(RandomSource var0, IntStream var1) {
        return new PerlinNoise(var0, PerlinNoise.makeAmplitudes((IntSortedSet)new IntRBTreeSet((Collection)var1.boxed().collect(ImmutableList.toImmutableList()))), false);
    }

    @Deprecated
    public static PerlinNoise createLegacyForLegacyNetherBiome(RandomSource var0, int var1, DoubleList var2) {
        return new PerlinNoise(var0, (Pair<Integer, DoubleList>)Pair.of((Object)var1, (Object)var2), false);
    }

    public static PerlinNoise create(RandomSource var0, IntStream var1) {
        return PerlinNoise.create(var0, (List)var1.boxed().collect(ImmutableList.toImmutableList()));
    }

    public static PerlinNoise create(RandomSource var0, List<Integer> var1) {
        return new PerlinNoise(var0, PerlinNoise.makeAmplitudes((IntSortedSet)new IntRBTreeSet(var1)), true);
    }

    public static PerlinNoise create(RandomSource var0, int var1, double var2, double ... var4) {
        DoubleArrayList var5 = new DoubleArrayList(var4);
        var5.add(0, var2);
        return new PerlinNoise(var0, (Pair<Integer, DoubleList>)Pair.of((Object)var1, (Object)var5), true);
    }

    public static PerlinNoise create(RandomSource var0, int var1, DoubleList var2) {
        return new PerlinNoise(var0, (Pair<Integer, DoubleList>)Pair.of((Object)var1, (Object)var2), true);
    }

    private static Pair<Integer, DoubleList> makeAmplitudes(IntSortedSet var0) {
        int var2;
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int var1 = -var0.firstInt();
        int var3 = var1 + (var2 = var0.lastInt()) + 1;
        if (var3 < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        DoubleArrayList var4 = new DoubleArrayList(new double[var3]);
        IntBidirectionalIterator var5 = var0.iterator();
        while (var5.hasNext()) {
            int var6 = var5.nextInt();
            var4.set(var6 + var1, 1.0);
        }
        return Pair.of((Object)(-var1), (Object)var4);
    }

    protected PerlinNoise(RandomSource var02, Pair<Integer, DoubleList> var1, boolean var2) {
        this.firstOctave = (Integer)var1.getFirst();
        this.amplitudes = (DoubleList)var1.getSecond();
        int var3 = this.amplitudes.size();
        int var4 = -this.firstOctave;
        this.noiseLevels = new ImprovedNoise[var3];
        if (var2) {
            PositionalRandomFactory var5 = var02.forkPositional();
            for (int var6 = 0; var6 < var3; ++var6) {
                if (this.amplitudes.getDouble(var6) == 0.0) continue;
                int var7 = this.firstOctave + var6;
                this.noiseLevels[var6] = new ImprovedNoise(var5.fromHashOf("octave_" + var7));
            }
        } else {
            double var6;
            ImprovedNoise var5 = new ImprovedNoise(var02);
            if (var4 >= 0 && var4 < var3 && (var6 = this.amplitudes.getDouble(var4)) != 0.0) {
                this.noiseLevels[var4] = var5;
            }
            for (int var62 = var4 - 1; var62 >= 0; --var62) {
                if (var62 < var3) {
                    double var7 = this.amplitudes.getDouble(var62);
                    if (var7 != 0.0) {
                        this.noiseLevels[var62] = new ImprovedNoise(var02);
                        continue;
                    }
                    PerlinNoise.skipOctave(var02);
                    continue;
                }
                PerlinNoise.skipOctave(var02);
            }
            if (Arrays.stream(this.noiseLevels).filter(Objects::nonNull).count() != this.amplitudes.stream().filter(var0 -> var0 != 0.0).count()) {
                throw new IllegalStateException("Failed to create correct number of noise levels for given non-zero amplitudes");
            }
            if (var4 < var3 - 1) {
                throw new IllegalArgumentException("Positive octaves are temporarily disabled");
            }
        }
        this.lowestFreqInputFactor = Math.pow(2.0, -var4);
        this.lowestFreqValueFactor = Math.pow(2.0, var3 - 1) / (Math.pow(2.0, var3) - 1.0);
        this.maxValue = this.edgeValue(2.0);
    }

    protected double maxValue() {
        return this.maxValue;
    }

    private static void skipOctave(RandomSource var0) {
        var0.consumeCount(262);
    }

    public double getValue(double var0, double var2, double var4) {
        return this.getValue(var0, var2, var4, 0.0, 0.0, false);
    }

    @Deprecated
    public double getValue(double var0, double var2, double var4, double var6, double var8, boolean var10) {
        double var11 = 0.0;
        double var13 = this.lowestFreqInputFactor;
        double var15 = this.lowestFreqValueFactor;
        for (int var17 = 0; var17 < this.noiseLevels.length; ++var17) {
            ImprovedNoise var18 = this.noiseLevels[var17];
            if (var18 != null) {
                double var19 = var18.noise(PerlinNoise.wrap(var0 * var13), var10 ? -var18.yo : PerlinNoise.wrap(var2 * var13), PerlinNoise.wrap(var4 * var13), var6 * var13, var8 * var13);
                var11 += this.amplitudes.getDouble(var17) * var19 * var15;
            }
            var13 *= 2.0;
            var15 /= 2.0;
        }
        return var11;
    }

    public double maxBrokenValue(double var0) {
        return this.edgeValue(var0 + 2.0);
    }

    private double edgeValue(double var0) {
        double var2 = 0.0;
        double var4 = this.lowestFreqValueFactor;
        for (int var6 = 0; var6 < this.noiseLevels.length; ++var6) {
            ImprovedNoise var7 = this.noiseLevels[var6];
            if (var7 != null) {
                var2 += this.amplitudes.getDouble(var6) * var0 * var4;
            }
            var4 /= 2.0;
        }
        return var2;
    }

    @Nullable
    public ImprovedNoise getOctaveNoise(int var0) {
        return this.noiseLevels[this.noiseLevels.length - 1 - var0];
    }

    public static double wrap(double var0) {
        return var0 - (double)Mth.lfloor(var0 / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    protected int firstOctave() {
        return this.firstOctave;
    }

    protected DoubleList amplitudes() {
        return this.amplitudes;
    }

    @VisibleForTesting
    public void parityConfigString(StringBuilder var02) {
        var02.append("PerlinNoise{");
        List<String> var1 = this.amplitudes.stream().map(var0 -> String.format(Locale.ROOT, "%.2f", var0)).toList();
        var02.append("first octave: ").append(this.firstOctave).append(", amplitudes: ").append(var1).append(", noise levels: [");
        for (int var2 = 0; var2 < this.noiseLevels.length; ++var2) {
            var02.append(var2).append(": ");
            ImprovedNoise var3 = this.noiseLevels[var2];
            if (var3 == null) {
                var02.append("null");
            } else {
                var3.parityConfigString(var02);
            }
            var02.append(", ");
        }
        var02.append("]");
        var02.append("}");
    }
}

