/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.BlockLightSectionStorage;
import net.minecraft.world.level.lighting.LightEngine;

public final class BlockLightEngine
extends LightEngine<BlockLightSectionStorage.BlockDataLayerStorageMap, BlockLightSectionStorage> {
    private final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();

    public BlockLightEngine(LightChunkGetter var0) {
        this(var0, new BlockLightSectionStorage(var0));
    }

    @VisibleForTesting
    public BlockLightEngine(LightChunkGetter var0, BlockLightSectionStorage var1) {
        super(var0, var1);
    }

    @Override
    protected void checkNode(long var0) {
        int var6;
        long var2 = SectionPos.blockToSection(var0);
        if (!((BlockLightSectionStorage)this.storage).storingLightForSection(var2)) {
            return;
        }
        BlockState var4 = this.getState(this.mutablePos.set(var0));
        int var5 = this.getEmission(var0, var4);
        if (var5 < (var6 = ((BlockLightSectionStorage)this.storage).getStoredLevel(var0))) {
            ((BlockLightSectionStorage)this.storage).setStoredLevel(var0, 0);
            this.enqueueDecrease(var0, LightEngine.QueueEntry.decreaseAllDirections(var6));
        } else {
            this.enqueueDecrease(var0, PULL_LIGHT_IN_ENTRY);
        }
        if (var5 > 0) {
            this.enqueueIncrease(var0, LightEngine.QueueEntry.increaseLightFromEmission(var5, BlockLightEngine.isEmptyShape(var4)));
        }
    }

    @Override
    protected void propagateIncrease(long var0, long var2, int var4) {
        BlockState var5 = null;
        for (Direction var9 : PROPAGATION_DIRECTIONS) {
            int var12;
            int var13;
            long var10;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(var2, var9) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(var10 = BlockPos.offset(var0, var9))) || (var13 = var4 - 1) <= (var12 = ((BlockLightSectionStorage)this.storage).getStoredLevel(var10))) continue;
            this.mutablePos.set(var10);
            BlockState var14 = this.getState(this.mutablePos);
            int var15 = var4 - this.getOpacity(var14);
            if (var15 <= var12) continue;
            if (var5 == null) {
                BlockState blockState = var5 = LightEngine.QueueEntry.isFromEmptyShape(var2) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(var0));
            }
            if (this.shapeOccludes(var5, var14, var9)) continue;
            ((BlockLightSectionStorage)this.storage).setStoredLevel(var10, var15);
            if (var15 <= 1) continue;
            this.enqueueIncrease(var10, LightEngine.QueueEntry.increaseSkipOneDirection(var15, BlockLightEngine.isEmptyShape(var14), var9.getOpposite()));
        }
    }

    @Override
    protected void propagateDecrease(long var0, long var2) {
        int var4 = LightEngine.QueueEntry.getFromLevel(var2);
        for (Direction var8 : PROPAGATION_DIRECTIONS) {
            int var11;
            long var9;
            if (!LightEngine.QueueEntry.shouldPropagateInDirection(var2, var8) || !((BlockLightSectionStorage)this.storage).storingLightForSection(SectionPos.blockToSection(var9 = BlockPos.offset(var0, var8))) || (var11 = ((BlockLightSectionStorage)this.storage).getStoredLevel(var9)) == 0) continue;
            if (var11 <= var4 - 1) {
                BlockState var12 = this.getState(this.mutablePos.set(var9));
                int var13 = this.getEmission(var9, var12);
                ((BlockLightSectionStorage)this.storage).setStoredLevel(var9, 0);
                if (var13 < var11) {
                    this.enqueueDecrease(var9, LightEngine.QueueEntry.decreaseSkipOneDirection(var11, var8.getOpposite()));
                }
                if (var13 <= 0) continue;
                this.enqueueIncrease(var9, LightEngine.QueueEntry.increaseLightFromEmission(var13, BlockLightEngine.isEmptyShape(var12)));
                continue;
            }
            this.enqueueIncrease(var9, LightEngine.QueueEntry.increaseOnlyOneDirection(var11, false, var8.getOpposite()));
        }
    }

    private int getEmission(long var0, BlockState var2) {
        int var3 = var2.getLightEmission();
        if (var3 > 0 && ((BlockLightSectionStorage)this.storage).lightOnInSection(SectionPos.blockToSection(var0))) {
            return var3;
        }
        return 0;
    }

    @Override
    public void propagateLightSources(ChunkPos var02) {
        this.setLightEnabled(var02, true);
        LightChunk var12 = this.chunkSource.getChunkForLighting(var02.x, var02.z);
        if (var12 != null) {
            var12.findBlockLightSources((var0, var1) -> {
                int var2 = var1.getLightEmission();
                this.enqueueIncrease(var0.asLong(), LightEngine.QueueEntry.increaseLightFromEmission(var2, BlockLightEngine.isEmptyShape(var1)));
            });
        }
    }
}

