/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class LightEngine<M extends DataLayerStorageMap<M>, S extends LayerLightSectionStorage<M>>
implements LayerLightEventListener {
    public static final int MAX_LEVEL = 15;
    protected static final int MIN_OPACITY = 1;
    protected static final long PULL_LIGHT_IN_ENTRY = QueueEntry.decreaseAllDirections(1);
    private static final int MIN_QUEUE_SIZE = 512;
    protected static final Direction[] PROPAGATION_DIRECTIONS = Direction.values();
    protected final LightChunkGetter chunkSource;
    protected final S storage;
    private final LongOpenHashSet blockNodesToCheck = new LongOpenHashSet(512, 0.5f);
    private final LongArrayFIFOQueue decreaseQueue = new LongArrayFIFOQueue();
    private final LongArrayFIFOQueue increaseQueue = new LongArrayFIFOQueue();
    private static final int CACHE_SIZE = 2;
    private final long[] lastChunkPos = new long[2];
    private final LightChunk[] lastChunk = new LightChunk[2];

    protected LightEngine(LightChunkGetter var0, S var1) {
        this.chunkSource = var0;
        this.storage = var1;
        this.clearChunkCache();
    }

    public static boolean hasDifferentLightProperties(BlockState var0, BlockState var1) {
        if (var1 == var0) {
            return false;
        }
        return var1.getLightBlock() != var0.getLightBlock() || var1.getLightEmission() != var0.getLightEmission() || var1.useShapeForLightOcclusion() || var0.useShapeForLightOcclusion();
    }

    public static int getLightBlockInto(BlockState var0, BlockState var1, Direction var2, int var3) {
        VoxelShape var7;
        boolean var4 = LightEngine.isEmptyShape(var0);
        boolean var5 = LightEngine.isEmptyShape(var1);
        if (var4 && var5) {
            return var3;
        }
        VoxelShape var6 = var4 ? Shapes.empty() : var0.getOcclusionShape();
        VoxelShape voxelShape = var7 = var5 ? Shapes.empty() : var1.getOcclusionShape();
        if (Shapes.mergedFaceOccludes(var6, var7, var2)) {
            return 16;
        }
        return var3;
    }

    public static VoxelShape getOcclusionShape(BlockState var0, Direction var1) {
        return LightEngine.isEmptyShape(var0) ? Shapes.empty() : var0.getFaceOcclusionShape(var1);
    }

    protected static boolean isEmptyShape(BlockState var0) {
        return !var0.canOcclude() || !var0.useShapeForLightOcclusion();
    }

    protected BlockState getState(BlockPos var0) {
        int var2;
        int var1 = SectionPos.blockToSectionCoord(var0.getX());
        LightChunk var3 = this.getChunk(var1, var2 = SectionPos.blockToSectionCoord(var0.getZ()));
        if (var3 == null) {
            return Blocks.BEDROCK.defaultBlockState();
        }
        return var3.getBlockState(var0);
    }

    protected int getOpacity(BlockState var0) {
        return Math.max(1, var0.getLightBlock());
    }

    protected boolean shapeOccludes(BlockState var0, BlockState var1, Direction var2) {
        VoxelShape var3 = LightEngine.getOcclusionShape(var0, var2);
        VoxelShape var4 = LightEngine.getOcclusionShape(var1, var2.getOpposite());
        return Shapes.faceShapeOccludes(var3, var4);
    }

    @Nullable
    protected LightChunk getChunk(int var0, int var1) {
        long var2 = ChunkPos.asLong(var0, var1);
        for (int var4 = 0; var4 < 2; ++var4) {
            if (var2 != this.lastChunkPos[var4]) continue;
            return this.lastChunk[var4];
        }
        LightChunk var4 = this.chunkSource.getChunkForLighting(var0, var1);
        for (int var5 = 1; var5 > 0; --var5) {
            this.lastChunkPos[var5] = this.lastChunkPos[var5 - 1];
            this.lastChunk[var5] = this.lastChunk[var5 - 1];
        }
        this.lastChunkPos[0] = var2;
        this.lastChunk[0] = var4;
        return var4;
    }

    private void clearChunkCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunk, null);
    }

    @Override
    public void checkBlock(BlockPos var0) {
        this.blockNodesToCheck.add(var0.asLong());
    }

    public void queueSectionData(long var0, @Nullable DataLayer var2) {
        ((LayerLightSectionStorage)this.storage).queueSectionData(var0, var2);
    }

    public void retainData(ChunkPos var0, boolean var1) {
        ((LayerLightSectionStorage)this.storage).retainData(SectionPos.getZeroNode(var0.x, var0.z), var1);
    }

    @Override
    public void updateSectionStatus(SectionPos var0, boolean var1) {
        ((LayerLightSectionStorage)this.storage).updateSectionStatus(var0.asLong(), var1);
    }

    @Override
    public void setLightEnabled(ChunkPos var0, boolean var1) {
        ((LayerLightSectionStorage)this.storage).setLightEnabled(SectionPos.getZeroNode(var0.x, var0.z), var1);
    }

    @Override
    public int runLightUpdates() {
        LongIterator var0 = this.blockNodesToCheck.iterator();
        while (var0.hasNext()) {
            this.checkNode(var0.nextLong());
        }
        this.blockNodesToCheck.clear();
        this.blockNodesToCheck.trim(512);
        int var1 = 0;
        var1 += this.propagateDecreases();
        this.clearChunkCache();
        ((LayerLightSectionStorage)this.storage).markNewInconsistencies(this);
        ((LayerLightSectionStorage)this.storage).swapSectionMap();
        return var1 += this.propagateIncreases();
    }

    private int propagateIncreases() {
        int var0 = 0;
        while (!this.increaseQueue.isEmpty()) {
            long var1 = this.increaseQueue.dequeueLong();
            long var3 = this.increaseQueue.dequeueLong();
            int var5 = ((LayerLightSectionStorage)this.storage).getStoredLevel(var1);
            int var6 = QueueEntry.getFromLevel(var3);
            if (QueueEntry.isIncreaseFromEmission(var3) && var5 < var6) {
                ((LayerLightSectionStorage)this.storage).setStoredLevel(var1, var6);
                var5 = var6;
            }
            if (var5 == var6) {
                this.propagateIncrease(var1, var3, var5);
            }
            ++var0;
        }
        return var0;
    }

    private int propagateDecreases() {
        int var0 = 0;
        while (!this.decreaseQueue.isEmpty()) {
            long var1 = this.decreaseQueue.dequeueLong();
            long var3 = this.decreaseQueue.dequeueLong();
            this.propagateDecrease(var1, var3);
            ++var0;
        }
        return var0;
    }

    protected void enqueueDecrease(long var0, long var2) {
        this.decreaseQueue.enqueue(var0);
        this.decreaseQueue.enqueue(var2);
    }

    protected void enqueueIncrease(long var0, long var2) {
        this.increaseQueue.enqueue(var0);
        this.increaseQueue.enqueue(var2);
    }

    @Override
    public boolean hasLightWork() {
        return ((LayerLightSectionStorage)this.storage).hasInconsistencies() || !this.blockNodesToCheck.isEmpty() || !this.decreaseQueue.isEmpty() || !this.increaseQueue.isEmpty();
    }

    @Override
    @Nullable
    public DataLayer getDataLayerData(SectionPos var0) {
        return ((LayerLightSectionStorage)this.storage).getDataLayerData(var0.asLong());
    }

    @Override
    public int getLightValue(BlockPos var0) {
        return ((LayerLightSectionStorage)this.storage).getLightValue(var0.asLong());
    }

    public String getDebugData(long var0) {
        return this.getDebugSectionType(var0).display();
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(long var0) {
        return ((LayerLightSectionStorage)this.storage).getDebugSectionType(var0);
    }

    protected abstract void checkNode(long var1);

    protected abstract void propagateIncrease(long var1, long var3, int var5);

    protected abstract void propagateDecrease(long var1, long var3);

    public static class QueueEntry {
        private static final int FROM_LEVEL_BITS = 4;
        private static final int DIRECTION_BITS = 6;
        private static final long LEVEL_MASK = 15L;
        private static final long DIRECTIONS_MASK = 1008L;
        private static final long FLAG_FROM_EMPTY_SHAPE = 1024L;
        private static final long FLAG_INCREASE_FROM_EMISSION = 2048L;

        public static long decreaseSkipOneDirection(int var0, Direction var1) {
            long var2 = QueueEntry.withoutDirection(1008L, var1);
            return QueueEntry.withLevel(var2, var0);
        }

        public static long decreaseAllDirections(int var0) {
            return QueueEntry.withLevel(1008L, var0);
        }

        public static long increaseLightFromEmission(int var0, boolean var1) {
            long var2 = 1008L;
            var2 |= 0x800L;
            if (var1) {
                var2 |= 0x400L;
            }
            return QueueEntry.withLevel(var2, var0);
        }

        public static long increaseSkipOneDirection(int var0, boolean var1, Direction var2) {
            long var3 = QueueEntry.withoutDirection(1008L, var2);
            if (var1) {
                var3 |= 0x400L;
            }
            return QueueEntry.withLevel(var3, var0);
        }

        public static long increaseOnlyOneDirection(int var0, boolean var1, Direction var2) {
            long var3 = 0L;
            if (var1) {
                var3 |= 0x400L;
            }
            var3 = QueueEntry.withDirection(var3, var2);
            return QueueEntry.withLevel(var3, var0);
        }

        public static long increaseSkySourceInDirections(boolean var0, boolean var1, boolean var2, boolean var3, boolean var4) {
            long var5 = QueueEntry.withLevel(0L, 15);
            if (var0) {
                var5 = QueueEntry.withDirection(var5, Direction.DOWN);
            }
            if (var1) {
                var5 = QueueEntry.withDirection(var5, Direction.NORTH);
            }
            if (var2) {
                var5 = QueueEntry.withDirection(var5, Direction.SOUTH);
            }
            if (var3) {
                var5 = QueueEntry.withDirection(var5, Direction.WEST);
            }
            if (var4) {
                var5 = QueueEntry.withDirection(var5, Direction.EAST);
            }
            return var5;
        }

        public static int getFromLevel(long var0) {
            return (int)(var0 & 0xFL);
        }

        public static boolean isFromEmptyShape(long var0) {
            return (var0 & 0x400L) != 0L;
        }

        public static boolean isIncreaseFromEmission(long var0) {
            return (var0 & 0x800L) != 0L;
        }

        public static boolean shouldPropagateInDirection(long var0, Direction var2) {
            return (var0 & 1L << var2.ordinal() + 4) != 0L;
        }

        private static long withLevel(long var0, int var2) {
            return var0 & 0xFFFFFFFFFFFFFFF0L | (long)var2 & 0xFL;
        }

        private static long withDirection(long var0, Direction var2) {
            return var0 | 1L << var2.ordinal() + 4;
        }

        private static long withoutDirection(long var0, Direction var2) {
            return var0 & (1L << var2.ordinal() + 4 ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

