/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class AmphibiousNodeEvaluator
extends WalkNodeEvaluator {
    private final boolean prefersShallowSwimming;
    private float oldWalkableCost;
    private float oldWaterBorderCost;

    public AmphibiousNodeEvaluator(boolean var0) {
        this.prefersShallowSwimming = var0;
    }

    @Override
    public void prepare(PathNavigationRegion var0, Mob var1) {
        super.prepare(var0, var1);
        var1.setPathfindingMalus(PathType.WATER, 0.0f);
        this.oldWalkableCost = var1.getPathfindingMalus(PathType.WALKABLE);
        var1.setPathfindingMalus(PathType.WALKABLE, 6.0f);
        this.oldWaterBorderCost = var1.getPathfindingMalus(PathType.WATER_BORDER);
        var1.setPathfindingMalus(PathType.WATER_BORDER, 4.0f);
    }

    @Override
    public void done() {
        this.mob.setPathfindingMalus(PathType.WALKABLE, this.oldWalkableCost);
        this.mob.setPathfindingMalus(PathType.WATER_BORDER, this.oldWaterBorderCost);
        super.done();
    }

    @Override
    public Node getStart() {
        if (!this.mob.isInWater()) {
            return super.getStart();
        }
        return this.getStartNode(new BlockPos(Mth.floor(this.mob.getBoundingBox().minX), Mth.floor(this.mob.getBoundingBox().minY + 0.5), Mth.floor(this.mob.getBoundingBox().minZ)));
    }

    @Override
    public Target getTarget(double var0, double var2, double var4) {
        return this.getTargetNodeAt(var0, var2 + 0.5, var4);
    }

    @Override
    public int getNeighbors(Node[] var0, Node var1) {
        int var2 = super.getNeighbors(var0, var1);
        PathType var4 = this.getCachedPathType(var1.x, var1.y + 1, var1.z);
        PathType var5 = this.getCachedPathType(var1.x, var1.y, var1.z);
        int var3 = this.mob.getPathfindingMalus(var4) >= 0.0f && var5 != PathType.STICKY_HONEY ? Mth.floor(Math.max(1.0f, this.mob.maxUpStep())) : 0;
        double var6 = this.getFloorLevel(new BlockPos(var1.x, var1.y, var1.z));
        Node var8 = this.findAcceptedNode(var1.x, var1.y + 1, var1.z, Math.max(0, var3 - 1), var6, Direction.UP, var5);
        Node var9 = this.findAcceptedNode(var1.x, var1.y - 1, var1.z, var3, var6, Direction.DOWN, var5);
        if (this.isVerticalNeighborValid(var8, var1)) {
            var0[var2++] = var8;
        }
        if (this.isVerticalNeighborValid(var9, var1) && var5 != PathType.TRAPDOOR) {
            var0[var2++] = var9;
        }
        for (int var10 = 0; var10 < var2; ++var10) {
            Node var11 = var0[var10];
            if (var11.type != PathType.WATER || !this.prefersShallowSwimming || var11.y >= this.mob.level().getSeaLevel() - 10) continue;
            var11.costMalus += 1.0f;
        }
        return var2;
    }

    private boolean isVerticalNeighborValid(@Nullable Node var0, Node var1) {
        return this.isNeighborValid(var0, var1) && var0.type == PathType.WATER;
    }

    @Override
    protected boolean isAmphibious() {
        return true;
    }

    @Override
    public PathType getPathType(PathfindingContext var0, int var1, int var2, int var3) {
        PathType var4 = var0.getPathTypeFromState(var1, var2, var3);
        if (var4 == PathType.WATER) {
            BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
            for (Direction var9 : Direction.values()) {
                var5.set(var1, var2, var3).move(var9);
                PathType var10 = var0.getPathTypeFromState(var5.getX(), var5.getY(), var5.getZ());
                if (var10 != PathType.BLOCKED) continue;
                return PathType.WATER_BORDER;
            }
            return PathType.WATER;
        }
        return super.getPathType(var0, var1, var2, var3);
    }
}

