/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.player.PlayerTeleportEvent;

public record TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, boolean missingRespawnBlock, boolean asPassenger, Set<Relative> relatives, PostTeleportTransition postTeleportTransition, PlayerTeleportEvent.TeleportCause cause) {
    public static final PostTeleportTransition DO_NOTHING = entity -> {};
    public static final PostTeleportTransition PLAY_PORTAL_SOUND = TeleportTransition::playPortalSound;
    public static final PostTeleportTransition PLACE_PORTAL_TICKET = TeleportTransition::placePortalTicket;

    public TeleportTransition(ServerLevel newLevel, Vec3 position, Vec3 deltaMovement, float yRot, float xRot, boolean missingRespawnBlock, boolean asPassenger, Set<Relative> relatives, PostTeleportTransition postTeleportTransition) {
        this(newLevel, position, deltaMovement, yRot, xRot, missingRespawnBlock, asPassenger, relatives, postTeleportTransition, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(PlayerTeleportEvent.TeleportCause cause) {
        this(null, Vec3.ZERO, Vec3.ZERO, 0.0f, 0.0f, false, false, Set.of(), DO_NOTHING, cause);
    }

    public TeleportTransition(ServerLevel worldserver, Vec3 vec3d, Vec3 vec3d1, float f, float f1, PostTeleportTransition teleporttransition_a) {
        this(worldserver, vec3d, vec3d1, f, f1, teleporttransition_a, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(ServerLevel worldserver, Vec3 vec3d, Vec3 vec3d1, float f, float f1, PostTeleportTransition teleporttransition_a, PlayerTeleportEvent.TeleportCause cause) {
        this(worldserver, vec3d, vec3d1, f, f1, Set.of(), teleporttransition_a, cause);
    }

    public TeleportTransition(ServerLevel worldserver, Vec3 vec3d, Vec3 vec3d1, float f, float f1, Set<Relative> set, PostTeleportTransition teleporttransition_a) {
        this(worldserver, vec3d, vec3d1, f, f1, set, teleporttransition_a, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(ServerLevel worldserver, Vec3 vec3d, Vec3 vec3d1, float f, float f1, Set<Relative> set, PostTeleportTransition teleporttransition_a, PlayerTeleportEvent.TeleportCause cause) {
        this(worldserver, vec3d, vec3d1, f, f1, false, false, set, teleporttransition_a, cause);
    }

    public TeleportTransition(ServerLevel worldserver, Entity entity, PostTeleportTransition teleporttransition_a) {
        this(worldserver, entity, teleporttransition_a, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public TeleportTransition(ServerLevel worldserver, Entity entity, PostTeleportTransition teleporttransition_a, PlayerTeleportEvent.TeleportCause cause) {
        this(worldserver, TeleportTransition.findAdjustedSharedSpawnPos(worldserver, entity), Vec3.ZERO, worldserver.getSharedSpawnAngle(), 0.0f, false, false, Set.of(), teleporttransition_a, cause);
    }

    private static void playPortalSound(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            entityplayer.connection.send(new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
        }
    }

    private static void placePortalTicket(Entity entity) {
        entity.placePortalTicket(BlockPos.containing(entity.position()));
    }

    public static TeleportTransition missingRespawnBlock(ServerLevel worldserver, Entity entity, PostTeleportTransition teleporttransition_a) {
        return new TeleportTransition(worldserver, TeleportTransition.findAdjustedSharedSpawnPos(worldserver, entity), Vec3.ZERO, worldserver.getSharedSpawnAngle(), 0.0f, true, false, Set.of(), teleporttransition_a);
    }

    private static Vec3 findAdjustedSharedSpawnPos(ServerLevel worldserver, Entity entity) {
        return entity.adjustSpawnLocation(worldserver, worldserver.getSharedSpawnPos()).getBottomCenter();
    }

    public TeleportTransition withRotation(float f, float f1) {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), f, f1, this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition withPosition(Vec3 vec3d) {
        return new TeleportTransition(this.newLevel(), vec3d, this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), this.asPassenger(), this.relatives(), this.postTeleportTransition());
    }

    public TeleportTransition transitionAsPassenger() {
        return new TeleportTransition(this.newLevel(), this.position(), this.deltaMovement(), this.yRot(), this.xRot(), this.missingRespawnBlock(), true, this.relatives(), this.postTeleportTransition());
    }

    @FunctionalInterface
    public static interface PostTeleportTransition {
        public void onTransition(Entity var1);

        default public PostTeleportTransition then(PostTeleportTransition teleporttransition_a) {
            return entity -> {
                this.onTransition(entity);
                teleporttransition_a.onTransition(entity);
            };
        }
    }
}

