/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class ExperimentalRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    private final Deque<BlockPos> wiresToTurnOff = new ArrayDeque<BlockPos>();
    private final Deque<BlockPos> wiresToTurnOn = new ArrayDeque<BlockPos>();
    private final Object2IntMap<BlockPos> updatedWires = new Object2IntLinkedOpenHashMap();

    public ExperimentalRedstoneWireEvaluator(RedStoneWireBlock blockredstonewire) {
        super(blockredstonewire);
    }

    @Override
    public void updatePowerStrength(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable Orientation orientation, boolean flag) {
        Orientation orientation1 = ExperimentalRedstoneWireEvaluator.getInitialOrientation(world, orientation);
        this.calculateCurrentChanges(world, blockposition, orientation1);
        ObjectIterator objectiterator = this.updatedWires.object2IntEntrySet().iterator();
        boolean flag1 = true;
        while (objectiterator.hasNext()) {
            Object2IntMap.Entry object2intmap_entry = (Object2IntMap.Entry)objectiterator.next();
            BlockPos blockposition1 = (BlockPos)object2intmap_entry.getKey();
            int i = object2intmap_entry.getIntValue();
            int j = ExperimentalRedstoneWireEvaluator.unpackPower(i);
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            int oldPower = iblockdata.getValue(RedStoneWireBlock.POWER);
            if (oldPower != j) {
                BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(world, blockposition1), oldPower, j);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                j = event.getNewCurrent();
            }
            if (iblockdata1.is(this.wireBlock) && oldPower != j) {
                int k = 2;
                if (!flag || !flag1) {
                    k |= 0x80;
                }
                world.setBlock(blockposition1, (BlockState)iblockdata1.setValue(RedStoneWireBlock.POWER, j), k);
            } else {
                objectiterator.remove();
            }
            flag1 = false;
        }
        this.causeNeighborUpdates(world);
    }

    private void causeNeighborUpdates(Level world) {
        this.updatedWires.forEach((blockposition, integer) -> {
            Orientation orientation = ExperimentalRedstoneWireEvaluator.unpackOrientation(integer);
            BlockState iblockdata = world.getBlockState((BlockPos)blockposition);
            for (Direction enumdirection : orientation.getDirections()) {
                if (!ExperimentalRedstoneWireEvaluator.isConnected(iblockdata, enumdirection)) continue;
                BlockPos blockposition1 = blockposition.relative(enumdirection);
                BlockState iblockdata1 = world.getBlockState(blockposition1);
                Orientation orientation1 = orientation.withFrontPreserveUp(enumdirection);
                world.neighborChanged(iblockdata1, blockposition1, this.wireBlock, orientation1, false);
                if (!iblockdata1.isRedstoneConductor(world, blockposition1)) continue;
                for (Direction enumdirection1 : orientation1.getDirections()) {
                    if (enumdirection1 == enumdirection.getOpposite()) continue;
                    world.neighborChanged(blockposition1.relative(enumdirection1), this.wireBlock, orientation1.withFrontPreserveUp(enumdirection1));
                }
            }
        });
    }

    private static boolean isConnected(BlockState iblockdata, Direction enumdirection) {
        EnumProperty<RedstoneSide> blockstateenum = RedStoneWireBlock.PROPERTY_BY_DIRECTION.get(enumdirection);
        return blockstateenum == null ? enumdirection == Direction.DOWN : iblockdata.getValue(blockstateenum).isConnected();
    }

    private static Orientation getInitialOrientation(Level world, @Nullable Orientation orientation) {
        Orientation orientation1 = orientation != null ? orientation : Orientation.random(world.random);
        return orientation1.withUp(Direction.UP).withSideBias(Orientation.SideBias.LEFT);
    }

    private void calculateCurrentChanges(Level world, BlockPos blockposition, Orientation orientation) {
        int i;
        BlockPos blockposition1;
        BlockState iblockdata = world.getBlockState(blockposition);
        if (iblockdata.is(this.wireBlock)) {
            this.setPower(blockposition, iblockdata.getValue(RedStoneWireBlock.POWER), orientation);
            this.wiresToTurnOff.add(blockposition);
        } else {
            this.propagateChangeToNeighbors(world, blockposition, 0, orientation, true);
        }
        while (!this.wiresToTurnOff.isEmpty()) {
            int k;
            int j1;
            blockposition1 = this.wiresToTurnOff.removeFirst();
            int l = this.updatedWires.getInt((Object)blockposition1);
            Orientation orientation1 = ExperimentalRedstoneWireEvaluator.unpackOrientation(l);
            i = ExperimentalRedstoneWireEvaluator.unpackPower(l);
            int i1 = this.getBlockSignal(world, blockposition1);
            int j = Math.max(i1, j1 = this.getIncomingWireSignal(world, blockposition1));
            if (j < i) {
                if (i1 > 0 && !this.wiresToTurnOn.contains(blockposition1)) {
                    this.wiresToTurnOn.add(blockposition1);
                }
                k = 0;
            } else {
                k = j;
            }
            if (k != i) {
                this.setPower(blockposition1, k, orientation1);
            }
            this.propagateChangeToNeighbors(world, blockposition1, k, orientation1, i > j);
        }
        while (!this.wiresToTurnOn.isEmpty()) {
            blockposition1 = this.wiresToTurnOn.removeFirst();
            int l1 = this.updatedWires.getInt((Object)blockposition1);
            int i2 = ExperimentalRedstoneWireEvaluator.unpackPower(l1);
            i = this.getBlockSignal(world, blockposition1);
            int j2 = this.getIncomingWireSignal(world, blockposition1);
            int k1 = Math.max(i, j2);
            Orientation orientation2 = ExperimentalRedstoneWireEvaluator.unpackOrientation(l1);
            if (k1 > i2) {
                this.setPower(blockposition1, k1, orientation2);
            } else if (k1 < i2) {
                throw new IllegalStateException("Turning off wire while trying to turn it on. Should not happen.");
            }
            this.propagateChangeToNeighbors(world, blockposition1, k1, orientation2, false);
        }
    }

    private static int packOrientationAndPower(Orientation orientation, int i) {
        return orientation.getIndex() << 4 | i;
    }

    private static Orientation unpackOrientation(int i) {
        return Orientation.fromIndex(i >> 4);
    }

    private static int unpackPower(int i) {
        return i & 0xF;
    }

    private void setPower(BlockPos blockposition, int i, Orientation orientation) {
        this.updatedWires.compute((Object)blockposition, (blockposition1, integer) -> integer == null ? ExperimentalRedstoneWireEvaluator.packOrientationAndPower(orientation, i) : ExperimentalRedstoneWireEvaluator.packOrientationAndPower(ExperimentalRedstoneWireEvaluator.unpackOrientation(integer), i));
    }

    private void propagateChangeToNeighbors(Level world, BlockPos blockposition, int i, Orientation orientation, boolean flag) {
        for (Direction enumdirection : orientation.getHorizontalDirections()) {
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            this.enqueueNeighborWire(world, blockposition1, i, orientation.withFront(enumdirection), flag);
        }
        for (Direction enumdirection1 : orientation.getVerticalDirections()) {
            BlockPos blockposition2 = blockposition.relative(enumdirection1);
            boolean flag1 = world.getBlockState(blockposition2).isRedstoneConductor(world, blockposition2);
            for (Direction enumdirection2 : orientation.getHorizontalDirections()) {
                BlockPos blockposition3 = blockposition.relative(enumdirection2);
                if (enumdirection1 == Direction.UP && !flag1) {
                    BlockPos blockposition4 = blockposition2.relative(enumdirection2);
                    this.enqueueNeighborWire(world, blockposition4, i, orientation.withFront(enumdirection2), flag);
                    continue;
                }
                if (enumdirection1 != Direction.DOWN || world.getBlockState(blockposition3).isRedstoneConductor(world, blockposition3)) continue;
                BlockPos blockposition5 = blockposition2.relative(enumdirection2);
                this.enqueueNeighborWire(world, blockposition5, i, orientation.withFront(enumdirection2), flag);
            }
        }
    }

    private void enqueueNeighborWire(Level world, BlockPos blockposition, int i, Orientation orientation, boolean flag) {
        BlockState iblockdata = world.getBlockState(blockposition);
        if (iblockdata.is(this.wireBlock)) {
            int j = this.getWireSignal(blockposition, iblockdata);
            if (j < i - 1 && !this.wiresToTurnOn.contains(blockposition)) {
                this.wiresToTurnOn.add(blockposition);
                this.setPower(blockposition, j, orientation);
            }
            if (flag && j > i && !this.wiresToTurnOff.contains(blockposition)) {
                this.wiresToTurnOff.add(blockposition);
                this.setPower(blockposition, j, orientation);
            }
        }
    }

    @Override
    protected int getWireSignal(BlockPos blockposition, BlockState iblockdata) {
        int i = this.updatedWires.getOrDefault((Object)blockposition, -1);
        return i != -1 ? ExperimentalRedstoneWireEvaluator.unpackPower(i) : super.getWireSignal(blockposition, iblockdata);
    }
}

