/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final SavedData.Context context;
    public final Map<SavedDataType<?>, Optional<SavedData>> cache = new HashMap();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(SavedData.Context var0, Path var1, DataFixer var2, HolderLookup.Provider var3) {
        this.context = var0;
        this.fixerUpper = var2;
        this.dataFolder = var1;
        this.registries = var3;
    }

    private Path getDataFile(String var0) {
        return this.dataFolder.resolve(var0 + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedDataType<T> var0) {
        T var1 = this.get(var0);
        if (var1 != null) {
            return var1;
        }
        SavedData var2 = (SavedData)var0.constructor().apply(this.context);
        this.set(var0, var2);
        return (T)var2;
    }

    @Nullable
    public <T extends SavedData> T get(SavedDataType<T> var0) {
        Optional<SavedData> var1 = this.cache.get(var0);
        if (var1 == null) {
            var1 = Optional.ofNullable(this.readSavedData(var0));
            this.cache.put(var0, var1);
        }
        return (T)((SavedData)var1.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(SavedDataType<T> var0) {
        try {
            Path var12 = this.getDataFile(var0.id());
            if (Files.exists(var12, new LinkOption[0])) {
                CompoundTag var2 = this.readTagFromDisk(var0.id(), var0.dataFixType(), SharedConstants.getCurrentVersion().dataVersion().version());
                RegistryOps<Tag> var3 = this.registries.createSerializationContext(NbtOps.INSTANCE);
                return (T)((SavedData)var0.codec().apply(this.context).parse(var3, (Object)var2.get("data")).resultOrPartial(var1 -> LOGGER.error("Failed to parse saved data for '{}': {}", (Object)var0, var1)).orElse(null));
            }
        }
        catch (Exception var13) {
            LOGGER.error("Error loading saved data: {}", var0, (Object)var13);
        }
        return null;
    }

    public <T extends SavedData> void set(SavedDataType<T> var0, T var1) {
        this.cache.put(var0, Optional.of(var1));
        var1.setDirty();
    }

    public CompoundTag readTagFromDisk(String var0, DataFixTypes var1, int var2) throws IOException {
        try (InputStream var3 = Files.newInputStream(this.getDataFile(var0), new OpenOption[0]);){
            CompoundTag compoundTag;
            try (PushbackInputStream var4 = new PushbackInputStream(new FastBufferedInputStream(var3), 2);){
                CompoundTag var5;
                if (this.isGzip(var4)) {
                    var5 = NbtIo.readCompressed(var4, NbtAccounter.unlimitedHeap());
                } else {
                    try (DataInputStream var6 = new DataInputStream(var4);){
                        var5 = NbtIo.read(var6);
                    }
                }
                int var6 = NbtUtils.getDataVersion(var5, 1343);
                compoundTag = var1.update(this.fixerUpper, var5, var6, var2);
            }
            return compoundTag;
        }
    }

    private boolean isGzip(PushbackInputStream var0) throws IOException {
        int var4;
        byte[] var1 = new byte[2];
        boolean var2 = false;
        int var3 = var0.read(var1, 0, 2);
        if (var3 == 2 && (var4 = (var1[1] & 0xFF) << 8 | var1[0] & 0xFF) == 35615) {
            var2 = true;
        }
        if (var3 != 0) {
            var0.unread(var1, 0, var3);
        }
        return var2;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<SavedDataType<?>, CompoundTag> var0 = this.collectDirtyTagsToSave();
        if (var0.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int var12 = Util.maxAllowedExecutorThreads();
        int var2 = var0.size();
        this.pendingWriteFuture = var2 > var12 ? this.pendingWriteFuture.thenCompose(var3 -> {
            ArrayList<CompletableFuture<Void>> var4 = new ArrayList<CompletableFuture<Void>>(var12);
            int var5 = Mth.positiveCeilDiv(var2, var12);
            for (List var7 : Iterables.partition(var0.entrySet(), (int)var5)) {
                var4.add(CompletableFuture.runAsync(() -> {
                    for (Map<SavedDataType<?>, CompoundTag> var0 : var7) {
                        this.tryWrite((SavedDataType)var0.getKey(), (CompoundTag)var0.getValue());
                    }
                }, Util.ioPool()));
            }
            return CompletableFuture.allOf((CompletableFuture[])var4.toArray(CompletableFuture[]::new));
        }) : this.pendingWriteFuture.thenCompose(var1 -> CompletableFuture.allOf((CompletableFuture[])var0.entrySet().stream().map(var0 -> CompletableFuture.runAsync(() -> this.tryWrite((SavedDataType)var0.getKey(), (CompoundTag)var0.getValue()), Util.ioPool())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<SavedDataType<?>, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap var0 = new Object2ObjectArrayMap();
        RegistryOps<Tag> var1 = this.registries.createSerializationContext(NbtOps.INSTANCE);
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$9((Map)var0, var1, arg_0, arg_1));
        return var0;
    }

    private <T extends SavedData> CompoundTag encodeUnchecked(SavedDataType<T> var0, SavedData var1, RegistryOps<Tag> var2) {
        Codec<T> var3 = var0.codec().apply(this.context);
        CompoundTag var4 = new CompoundTag();
        var4.put("data", (Tag)var3.encodeStart(var2, (Object)var1).getOrThrow());
        NbtUtils.addCurrentDataVersion(var4);
        return var4;
    }

    private void tryWrite(SavedDataType<?> var0, CompoundTag var1) {
        Path var2 = this.getDataFile(var0.id());
        try {
            NbtIo.writeCompressed(var1, var2);
        }
        catch (IOException var3) {
            LOGGER.error("Could not save data to {}", (Object)var2.getFileName(), (Object)var3);
        }
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$9(Map var0, RegistryOps var1, SavedDataType var2, Optional var32) {
        var32.filter(SavedData::isDirty).ifPresent(var3 -> {
            var0.put(var2, this.encodeUnchecked(var2, (SavedData)var3, var1));
            var3.setDirty(false);
        });
    }
}

