/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class TagEntry
extends LootPoolSingletonContainer {
    public static final MapCodec<TagEntry> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)TagKey.codec(Registries.ITEM).fieldOf("name").forGetter(var0 -> var0.tag), (App)Codec.BOOL.fieldOf("expand").forGetter(var0 -> var0.expand)).and(TagEntry.singletonFields(var02)).apply((Applicative)var02, TagEntry::new));
    private final TagKey<Item> tag;
    private final boolean expand;

    private TagEntry(TagKey<Item> var0, boolean var1, int var2, int var3, List<LootItemCondition> var4, List<LootItemFunction> var5) {
        super(var2, var3, var4, var5);
        this.tag = var0;
        this.expand = var1;
    }

    @Override
    public LootPoolEntryType getType() {
        return LootPoolEntries.TAG;
    }

    @Override
    public void createItemStack(Consumer<ItemStack> var0, LootContext var12) {
        BuiltInRegistries.ITEM.getTagOrEmpty(this.tag).forEach(var1 -> var0.accept(new ItemStack((Holder<Item>)var1)));
    }

    private boolean expandTag(LootContext var0, Consumer<LootPoolEntry> var1) {
        if (this.canRun(var0)) {
            for (final Holder<Item> var3 : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
                var1.accept(new LootPoolSingletonContainer.EntryBase(this){

                    @Override
                    public void createItemStack(Consumer<ItemStack> var0, LootContext var1) {
                        var0.accept(new ItemStack(var3));
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean expand(LootContext var0, Consumer<LootPoolEntry> var1) {
        if (this.expand) {
            return this.expandTag(var0, var1);
        }
        return super.expand(var0, var1);
    }

    public static LootPoolSingletonContainer.Builder<?> tagContents(TagKey<Item> var0) {
        return TagEntry.simpleBuilder((var1, var2, var3, var4) -> new TagEntry(var0, false, var1, var2, var3, var4));
    }

    public static LootPoolSingletonContainer.Builder<?> expandTag(TagKey<Item> var0) {
        return TagEntry.simpleBuilder((var1, var2, var3, var4) -> new TagEntry(var0, true, var1, var2, var3, var4));
    }
}

