/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class CopyNameFunction
extends LootItemConditionalFunction {
    public static final MapCodec<CopyNameFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> CopyNameFunction.commonFields(var02).and((App)NameSource.CODEC.fieldOf("source").forGetter(var0 -> var0.source)).apply((Applicative)var02, CopyNameFunction::new));
    private final NameSource source;

    private CopyNameFunction(List<LootItemCondition> var0, NameSource var1) {
        super(var0);
        this.source = var1;
    }

    public LootItemFunctionType<CopyNameFunction> getType() {
        return LootItemFunctions.COPY_NAME;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.param);
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        Object var2 = var1.getOptionalParameter(this.source.param);
        if (var2 instanceof Nameable) {
            Nameable var3 = (Nameable)var2;
            var0.set(DataComponents.CUSTOM_NAME, var3.getCustomName());
        }
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> copyName(NameSource var0) {
        return CopyNameFunction.simpleBuilder(var1 -> new CopyNameFunction((List<LootItemCondition>)var1, var0));
    }

    public static enum NameSource implements StringRepresentable
    {
        THIS("this", LootContextParams.THIS_ENTITY),
        ATTACKING_ENTITY("attacking_entity", LootContextParams.ATTACKING_ENTITY),
        LAST_DAMAGE_PLAYER("last_damage_player", LootContextParams.LAST_DAMAGE_PLAYER),
        BLOCK_ENTITY("block_entity", LootContextParams.BLOCK_ENTITY);

        public static final Codec<NameSource> CODEC;
        private final String name;
        final ContextKey<?> param;

        private NameSource(String var2, ContextKey var3) {
            this.name = var2;
            this.param = var3;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(NameSource::values);
        }
    }
}

