/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetBannerPatternFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetBannerPatternFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetBannerPatternFunction.commonFields(var02).and(var02.group((App)BannerPatternLayers.CODEC.fieldOf("patterns").forGetter(var0 -> var0.patterns), (App)Codec.BOOL.fieldOf("append").forGetter(var0 -> var0.append))).apply((Applicative)var02, SetBannerPatternFunction::new));
    private final BannerPatternLayers patterns;
    private final boolean append;

    SetBannerPatternFunction(List<LootItemCondition> var0, BannerPatternLayers var1, boolean var2) {
        super(var0);
        this.patterns = var1;
        this.append = var2;
    }

    @Override
    protected ItemStack run(ItemStack var02, LootContext var12) {
        if (this.append) {
            var02.update(DataComponents.BANNER_PATTERNS, BannerPatternLayers.EMPTY, this.patterns, (var0, var1) -> new BannerPatternLayers.Builder().addAll((BannerPatternLayers)var0).addAll((BannerPatternLayers)var1).build());
        } else {
            var02.set(DataComponents.BANNER_PATTERNS, this.patterns);
        }
        return var02;
    }

    public LootItemFunctionType<SetBannerPatternFunction> getType() {
        return LootItemFunctions.SET_BANNER_PATTERN;
    }

    public static Builder setBannerPattern(boolean var0) {
        return new Builder(var0);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final BannerPatternLayers.Builder patterns = new BannerPatternLayers.Builder();
        private final boolean append;

        Builder(boolean var0) {
            this.append = var0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetBannerPatternFunction(this.getConditions(), this.patterns.build(), this.append);
        }

        public Builder addPattern(Holder<BannerPattern> var0, DyeColor var1) {
            this.patterns.add(var0, var1);
            return this;
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

