/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.slf4j.Logger;

public class SetItemDamageFunction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<SetItemDamageFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetItemDamageFunction.commonFields(var02).and(var02.group((App)NumberProviders.CODEC.fieldOf("damage").forGetter(var0 -> var0.damage), (App)Codec.BOOL.fieldOf("add").orElse((Object)false).forGetter(var0 -> var0.add))).apply((Applicative)var02, SetItemDamageFunction::new));
    private final NumberProvider damage;
    private final boolean add;

    private SetItemDamageFunction(List<LootItemCondition> var0, NumberProvider var1, boolean var2) {
        super(var0);
        this.damage = var1;
        this.add = var2;
    }

    public LootItemFunctionType<SetItemDamageFunction> getType() {
        return LootItemFunctions.SET_DAMAGE;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.damage.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var1) {
        if (var0.isDamageableItem()) {
            int var2 = var0.getMaxDamage();
            float var3 = this.add ? 1.0f - (float)var0.getDamageValue() / (float)var2 : 0.0f;
            float var4 = 1.0f - Mth.clamp(this.damage.getFloat(var1) + var3, 0.0f, 1.0f);
            var0.setDamageValue(Mth.floor(var4 * (float)var2));
        } else {
            LOGGER.warn("Couldn't set damage of loot item {}", (Object)var0);
        }
        return var0;
    }

    public static LootItemConditionalFunction.Builder<?> setDamage(NumberProvider var0) {
        return SetItemDamageFunction.simpleBuilder(var1 -> new SetItemDamageFunction((List<LootItemCondition>)var1, var0, false));
    }

    public static LootItemConditionalFunction.Builder<?> setDamage(NumberProvider var0, boolean var1) {
        return SetItemDamageFunction.simpleBuilder(var2 -> new SetItemDamageFunction((List<LootItemCondition>)var2, var0, var1));
    }
}

