/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetLoreFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetLoreFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetLoreFunction.commonFields(var02).and(var02.group((App)ComponentSerialization.CODEC.sizeLimitedListOf(256).fieldOf("lore").forGetter(var0 -> var0.lore), (App)ListOperation.codec(256).forGetter(var0 -> var0.mode), (App)LootContext.EntityTarget.CODEC.optionalFieldOf("entity").forGetter(var0 -> var0.resolutionContext))).apply((Applicative)var02, SetLoreFunction::new));
    private final List<Component> lore;
    private final ListOperation mode;
    private final Optional<LootContext.EntityTarget> resolutionContext;

    public SetLoreFunction(List<LootItemCondition> var0, List<Component> var1, ListOperation var2, Optional<LootContext.EntityTarget> var3) {
        super(var0);
        this.lore = List.copyOf(var1);
        this.mode = var2;
        this.resolutionContext = var3;
    }

    public LootItemFunctionType<SetLoreFunction> getType() {
        return LootItemFunctions.SET_LORE;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.resolutionContext.map(var0 -> Set.of(var0.getParam())).orElseGet(Set::of);
    }

    @Override
    public ItemStack run(ItemStack var0, LootContext var12) {
        var0.update(DataComponents.LORE, ItemLore.EMPTY, var1 -> new ItemLore(this.updateLore((ItemLore)var1, var12)));
        return var0;
    }

    private List<Component> updateLore(@Nullable ItemLore var0, LootContext var1) {
        if (var0 == null && this.lore.isEmpty()) {
            return List.of();
        }
        UnaryOperator<Component> var2 = SetNameFunction.createResolver(var1, this.resolutionContext.orElse(null));
        List var3 = this.lore.stream().map(var2).toList();
        return this.mode.apply(var0.lines(), var3, 256);
    }

    public static Builder setLore() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private Optional<LootContext.EntityTarget> resolutionContext = Optional.empty();
        private final ImmutableList.Builder<Component> lore = ImmutableList.builder();
        private ListOperation mode = ListOperation.Append.INSTANCE;

        public Builder setMode(ListOperation var0) {
            this.mode = var0;
            return this;
        }

        public Builder setResolutionContext(LootContext.EntityTarget var0) {
            this.resolutionContext = Optional.of(var0);
            return this;
        }

        public Builder addLine(Component var0) {
            this.lore.add((Object)var0);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetLoreFunction(this.getConditions(), (List<Component>)this.lore.build(), this.mode, this.resolutionContext);
        }

        @Override
        protected /* synthetic */ LootItemConditionalFunction.Builder getThis() {
            return this.getThis();
        }
    }
}

