/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.timers;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.UnsignedLong;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.level.timers.TimerCallbacks;
import org.slf4j.Logger;

public class TimerQueue<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String CALLBACK_DATA_TAG = "Callback";
    private static final String TIMER_NAME_TAG = "Name";
    private static final String TIMER_TRIGGER_TIME_TAG = "TriggerTime";
    private final TimerCallbacks<T> callbacksRegistry;
    private final Queue<Event<T>> queue = new PriorityQueue<Event<T>>(TimerQueue.createComparator());
    private UnsignedLong sequentialId = UnsignedLong.ZERO;
    private final Table<String, Long, Event<T>> events = HashBasedTable.create();

    private static <T> Comparator<Event<T>> createComparator() {
        return Comparator.comparingLong(var0 -> var0.triggerTime).thenComparing(var0 -> var0.sequentialId);
    }

    public TimerQueue(TimerCallbacks<T> var02, Stream<? extends Dynamic<?>> var1) {
        this(var02);
        this.queue.clear();
        this.events.clear();
        this.sequentialId = UnsignedLong.ZERO;
        var1.forEach(var0 -> {
            Tag var1 = (Tag)var0.convert((DynamicOps)NbtOps.INSTANCE).getValue();
            if (var1 instanceof CompoundTag) {
                CompoundTag var2 = (CompoundTag)var1;
                this.loadEvent(var2);
            } else {
                LOGGER.warn("Invalid format of events: {}", (Object)var1);
            }
        });
    }

    public TimerQueue(TimerCallbacks<T> var0) {
        this.callbacksRegistry = var0;
    }

    public void tick(T var0, long var1) {
        Event<T> var3;
        while ((var3 = this.queue.peek()) != null && var3.triggerTime <= var1) {
            this.queue.remove();
            this.events.remove((Object)var3.id, (Object)var1);
            var3.callback.handle(var0, this, var1);
        }
    }

    public void schedule(String var0, long var1, TimerCallback<T> var3) {
        if (this.events.contains((Object)var0, (Object)var1)) {
            return;
        }
        this.sequentialId = this.sequentialId.plus(UnsignedLong.ONE);
        Event<T> var4 = new Event<T>(var1, this.sequentialId, var0, var3);
        this.events.put((Object)var0, (Object)var1, var4);
        this.queue.add(var4);
    }

    public int remove(String var0) {
        Collection var1 = this.events.row((Object)var0).values();
        var1.forEach(this.queue::remove);
        int var2 = var1.size();
        var1.clear();
        return var2;
    }

    public Set<String> getEventsIds() {
        return Collections.unmodifiableSet(this.events.rowKeySet());
    }

    private void loadEvent(CompoundTag var0) {
        TimerCallback var1 = var0.read(CALLBACK_DATA_TAG, this.callbacksRegistry.codec()).orElse(null);
        if (var1 != null) {
            String var2 = var0.getStringOr(TIMER_NAME_TAG, "");
            long var3 = var0.getLongOr(TIMER_TRIGGER_TIME_TAG, 0L);
            this.schedule(var2, var3, var1);
        }
    }

    private CompoundTag storeEvent(Event<T> var0) {
        CompoundTag var1 = new CompoundTag();
        var1.putString(TIMER_NAME_TAG, var0.id);
        var1.putLong(TIMER_TRIGGER_TIME_TAG, var0.triggerTime);
        var1.store(CALLBACK_DATA_TAG, this.callbacksRegistry.codec(), var0.callback);
        return var1;
    }

    public ListTag store() {
        ListTag var0 = new ListTag();
        this.queue.stream().sorted(TimerQueue.createComparator()).map(this::storeEvent).forEach(var0::add);
        return var0;
    }

    public static class Event<T> {
        public final long triggerTime;
        public final UnsignedLong sequentialId;
        public final String id;
        public final TimerCallback<T> callback;

        Event(long var0, UnsignedLong var2, String var3, TimerCallback<T> var4) {
            this.triggerTime = var0;
            this.sequentialId = var2;
            this.id = var3;
            this.callback = var4;
        }
    }
}

