/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EntityCollisionContext
implements CollisionContext {
    protected static final CollisionContext EMPTY = new EntityCollisionContext(false, false, -1.7976931348623157E308, ItemStack.EMPTY, var0 -> false, null){

        @Override
        public boolean isAbove(VoxelShape var0, BlockPos var1, boolean var2) {
            return var2;
        }
    };
    private final boolean descending;
    private final double entityBottom;
    private final boolean placement;
    private final ItemStack heldItem;
    private final Predicate<FluidState> canStandOnFluid;
    @Nullable
    private final Entity entity;

    protected EntityCollisionContext(boolean var0, boolean var1, double var2, ItemStack var4, Predicate<FluidState> var5, @Nullable Entity var6) {
        this.descending = var0;
        this.placement = var1;
        this.entityBottom = var2;
        this.heldItem = var4;
        this.canStandOnFluid = var5;
        this.entity = var6;
    }

    @Deprecated
    protected EntityCollisionContext(Entity var02, boolean var12, boolean var2) {
        Predicate<FluidState> predicate;
        ItemStack itemStack;
        LivingEntity var3;
        boolean bl = var02.isDescending();
        double d = var02.getY();
        if (var02 instanceof LivingEntity) {
            var3 = (LivingEntity)var02;
            itemStack = var3.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (var12) {
            predicate = var0 -> true;
        } else if (var02 instanceof LivingEntity) {
            var3 = (LivingEntity)var02;
            predicate = var1 -> var3.canStandOnFluid((FluidState)var1);
        } else {
            predicate = var0 -> false;
        }
        this(bl, var2, d, itemStack, predicate, var02);
    }

    @Override
    public boolean isHoldingItem(Item var0) {
        return this.heldItem.is(var0);
    }

    @Override
    public boolean canStandOnFluid(FluidState var0, FluidState var1) {
        return this.canStandOnFluid.test(var1) && !var0.getType().isSame(var1.getType());
    }

    @Override
    public VoxelShape getCollisionShape(BlockState var0, CollisionGetter var1, BlockPos var2) {
        return var0.getCollisionShape(var1, var2, this);
    }

    @Override
    public boolean isDescending() {
        return this.descending;
    }

    @Override
    public boolean isAbove(VoxelShape var0, BlockPos var1, boolean var2) {
        return this.entityBottom > (double)var1.getY() + var0.max(Direction.Axis.Y) - (double)1.0E-5f;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public boolean isPlacement() {
        return this.placement;
    }
}

