/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class ScoreboardSaveData
extends SavedData {
    public static final String FILE_ID = "scoreboard";
    private final Scoreboard scoreboard;

    public ScoreboardSaveData(Scoreboard var0) {
        this.scoreboard = var0;
    }

    public void loadFrom(Packed var02) {
        var02.objectives().forEach(this.scoreboard::loadObjective);
        var02.scores().forEach(this.scoreboard::loadPlayerScore);
        var02.displaySlots().forEach((var0, var1) -> {
            Objective var2 = this.scoreboard.getObjective((String)var1);
            this.scoreboard.setDisplayObjective((DisplaySlot)var0, var2);
        });
        var02.teams().forEach(this.scoreboard::loadPlayerTeam);
    }

    public Packed pack() {
        EnumMap<DisplaySlot, String> var0 = new EnumMap<DisplaySlot, String>(DisplaySlot.class);
        for (DisplaySlot var4 : DisplaySlot.values()) {
            Objective var5 = this.scoreboard.getDisplayObjective(var4);
            if (var5 == null) continue;
            var0.put(var4, var5.getName());
        }
        return new Packed(this.scoreboard.getObjectives().stream().map(Objective::pack).toList(), this.scoreboard.packPlayerScores(), var0, this.scoreboard.getPlayerTeams().stream().map(PlayerTeam::pack).toList());
    }

    public record Packed(List<Objective.Packed> objectives, List<Scoreboard.PackedScore> scores, Map<DisplaySlot, String> displaySlots, List<PlayerTeam.Packed> teams) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Objective.Packed.CODEC.listOf().optionalFieldOf("Objectives", List.of()).forGetter(Packed::objectives), (App)Scoreboard.PackedScore.CODEC.listOf().optionalFieldOf("PlayerScores", List.of()).forGetter(Packed::scores), (App)Codec.unboundedMap(DisplaySlot.CODEC, (Codec)Codec.STRING).optionalFieldOf("DisplaySlots", Map.of()).forGetter(Packed::displaySlots), (App)PlayerTeam.Packed.CODEC.listOf().optionalFieldOf("Teams", List.of()).forGetter(Packed::teams)).apply((Applicative)var0, Packed::new));
    }
}

