/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores.criteria;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import net.minecraft.util.StringRepresentable;

public class ObjectiveCriteria {
    private static final Map<String, ObjectiveCriteria> CUSTOM_CRITERIA = Maps.newHashMap();
    public static final Map<String, ObjectiveCriteria> CRITERIA_CACHE = Maps.newHashMap();
    public static final Codec<ObjectiveCriteria> CODEC = Codec.STRING.comapFlatMap(var0 -> ObjectiveCriteria.byName(var0).map(DataResult::success).orElse(DataResult.error(() -> "No scoreboard criteria with name: " + var0)), ObjectiveCriteria::getName);
    public static final ObjectiveCriteria DUMMY = ObjectiveCriteria.registerCustom("dummy");
    public static final ObjectiveCriteria TRIGGER = ObjectiveCriteria.registerCustom("trigger");
    public static final ObjectiveCriteria DEATH_COUNT = ObjectiveCriteria.registerCustom("deathCount");
    public static final ObjectiveCriteria KILL_COUNT_PLAYERS = ObjectiveCriteria.registerCustom("playerKillCount");
    public static final ObjectiveCriteria KILL_COUNT_ALL = ObjectiveCriteria.registerCustom("totalKillCount");
    public static final ObjectiveCriteria HEALTH = ObjectiveCriteria.registerCustom("health", true, RenderType.HEARTS);
    public static final ObjectiveCriteria FOOD = ObjectiveCriteria.registerCustom("food", true, RenderType.INTEGER);
    public static final ObjectiveCriteria AIR = ObjectiveCriteria.registerCustom("air", true, RenderType.INTEGER);
    public static final ObjectiveCriteria ARMOR = ObjectiveCriteria.registerCustom("armor", true, RenderType.INTEGER);
    public static final ObjectiveCriteria EXPERIENCE = ObjectiveCriteria.registerCustom("xp", true, RenderType.INTEGER);
    public static final ObjectiveCriteria LEVEL = ObjectiveCriteria.registerCustom("level", true, RenderType.INTEGER);
    public static final ObjectiveCriteria[] TEAM_KILL = new ObjectiveCriteria[]{ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.BLACK.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.DARK_BLUE.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.DARK_GREEN.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.DARK_AQUA.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.DARK_RED.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.DARK_PURPLE.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.GOLD.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.GRAY.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.DARK_GRAY.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.BLUE.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.GREEN.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.AQUA.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.RED.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.LIGHT_PURPLE.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.YELLOW.getName()), ObjectiveCriteria.registerCustom("teamkill." + ChatFormatting.WHITE.getName())};
    public static final ObjectiveCriteria[] KILLED_BY_TEAM = new ObjectiveCriteria[]{ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.BLACK.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.DARK_BLUE.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.DARK_GREEN.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.DARK_AQUA.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.DARK_RED.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.DARK_PURPLE.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.GOLD.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.GRAY.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.DARK_GRAY.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.BLUE.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.GREEN.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.AQUA.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.RED.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.LIGHT_PURPLE.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.YELLOW.getName()), ObjectiveCriteria.registerCustom("killedByTeam." + ChatFormatting.WHITE.getName())};
    private final String name;
    private final boolean readOnly;
    private final RenderType renderType;

    private static ObjectiveCriteria registerCustom(String var0, boolean var1, RenderType var2) {
        ObjectiveCriteria var3 = new ObjectiveCriteria(var0, var1, var2);
        CUSTOM_CRITERIA.put(var0, var3);
        return var3;
    }

    private static ObjectiveCriteria registerCustom(String var0) {
        return ObjectiveCriteria.registerCustom(var0, false, RenderType.INTEGER);
    }

    protected ObjectiveCriteria(String var0) {
        this(var0, false, RenderType.INTEGER);
    }

    protected ObjectiveCriteria(String var0, boolean var1, RenderType var2) {
        this.name = var0;
        this.readOnly = var1;
        this.renderType = var2;
        CRITERIA_CACHE.put(var0, this);
    }

    public static Set<String> getCustomCriteriaNames() {
        return ImmutableSet.copyOf(CUSTOM_CRITERIA.keySet());
    }

    public static Optional<ObjectiveCriteria> byName(String var0) {
        ObjectiveCriteria var1 = CRITERIA_CACHE.get(var0);
        if (var1 != null) {
            return Optional.of(var1);
        }
        int var22 = var0.indexOf(58);
        if (var22 < 0) {
            return Optional.empty();
        }
        return BuiltInRegistries.STAT_TYPE.getOptional(ResourceLocation.bySeparator(var0.substring(0, var22), '.')).flatMap(var2 -> ObjectiveCriteria.getStat(var2, ResourceLocation.bySeparator(var0.substring(var22 + 1), '.')));
    }

    private static <T> Optional<ObjectiveCriteria> getStat(StatType<T> var0, ResourceLocation var1) {
        return var0.getRegistry().getOptional(var1).map(var0::get);
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public RenderType getDefaultRenderType() {
        return this.renderType;
    }

    public static enum RenderType implements StringRepresentable
    {
        INTEGER("integer"),
        HEARTS("hearts");

        private final String id;
        public static final StringRepresentable.EnumCodec<RenderType> CODEC;

        private RenderType(String var2) {
            this.id = var2;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        public static RenderType byId(String var0) {
            return CODEC.byName(var0, INTEGER);
        }

        static {
            CODEC = StringRepresentable.fromEnum(RenderType::values);
        }
    }
}

