/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Hash;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public record SavedTick<T>(T type, BlockPos pos, int delay, TickPriority priority) {
    public static final Hash.Strategy<SavedTick<?>> UNIQUE_TICK_HASH = new Hash.Strategy<SavedTick<?>>(){

        public int hashCode(SavedTick<?> var0) {
            return 31 * var0.pos().hashCode() + var0.type().hashCode();
        }

        public boolean equals(@Nullable SavedTick<?> var0, @Nullable SavedTick<?> var1) {
            if (var0 == var1) {
                return true;
            }
            if (var0 == null || var1 == null) {
                return false;
            }
            return var0.type() == var1.type() && var0.pos().equals(var1.pos());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.equals((SavedTick)object, (SavedTick)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.hashCode((SavedTick)object);
        }
    };

    public static <T> Codec<SavedTick<T>> codec(Codec<T> var02) {
        MapCodec var1 = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.INT.fieldOf("x").forGetter(Vec3i::getX), (App)Codec.INT.fieldOf("y").forGetter(Vec3i::getY), (App)Codec.INT.fieldOf("z").forGetter(Vec3i::getZ)).apply((Applicative)var0, BlockPos::new));
        return RecordCodecBuilder.create(var2 -> var2.group((App)var02.fieldOf("i").forGetter(SavedTick::type), (App)var1.forGetter(SavedTick::pos), (App)Codec.INT.fieldOf("t").forGetter(SavedTick::delay), (App)TickPriority.CODEC.fieldOf("p").forGetter(SavedTick::priority)).apply((Applicative)var2, SavedTick::new));
    }

    public static <T> List<SavedTick<T>> filterTickListForChunk(List<SavedTick<T>> var0, ChunkPos var1) {
        long var22 = var1.toLong();
        return var0.stream().filter(var2 -> ChunkPos.asLong(var2.pos()) == var22).toList();
    }

    public ScheduledTick<T> unpack(long var0, long var2) {
        return new ScheduledTick<T>(this.type, this.pos, var0 + (long)this.delay, this.priority, var2);
    }

    public static <T> SavedTick<T> probe(T var0, BlockPos var1) {
        return new SavedTick<T>(var0, var1, 0, TickPriority.NORMAL);
    }
}

