/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.ticks.SavedTick;
import net.minecraft.world.ticks.TickPriority;

public record ScheduledTick<T>(T type, BlockPos pos, long triggerTick, TickPriority priority, long subTickOrder) {
    public static final Comparator<ScheduledTick<?>> DRAIN_ORDER = (var0, var1) -> {
        int var2 = Long.compare(var0.triggerTick, var1.triggerTick);
        if (var2 != 0) {
            return var2;
        }
        var2 = var0.priority.compareTo(var1.priority);
        if (var2 != 0) {
            return var2;
        }
        return Long.compare(var0.subTickOrder, var1.subTickOrder);
    };
    public static final Comparator<ScheduledTick<?>> INTRA_TICK_DRAIN_ORDER = (var0, var1) -> {
        int var2 = var0.priority.compareTo(var1.priority);
        if (var2 != 0) {
            return var2;
        }
        return Long.compare(var0.subTickOrder, var1.subTickOrder);
    };
    public static final Hash.Strategy<ScheduledTick<?>> UNIQUE_TICK_HASH = new Hash.Strategy<ScheduledTick<?>>(){

        public int hashCode(ScheduledTick<?> var0) {
            return 31 * var0.pos().hashCode() + var0.type().hashCode();
        }

        public boolean equals(@Nullable ScheduledTick<?> var0, @Nullable ScheduledTick<?> var1) {
            if (var0 == var1) {
                return true;
            }
            if (var0 == null || var1 == null) {
                return false;
            }
            return var0.type() == var1.type() && var0.pos().equals(var1.pos());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.equals((ScheduledTick)object, (ScheduledTick)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.hashCode((ScheduledTick)object);
        }
    };

    public ScheduledTick(T var0, BlockPos var1, long var2, long var4) {
        this(var0, var1, var2, TickPriority.NORMAL, var4);
    }

    public ScheduledTick {
        var1 = var1.immutable();
    }

    public static <T> ScheduledTick<T> probe(T var0, BlockPos var1) {
        return new ScheduledTick<T>(var0, var1, 0L, TickPriority.NORMAL, 0L);
    }

    public SavedTick<T> toSavedTick(long var0) {
        return new SavedTick<T>(this.type, this.pos, (int)(this.triggerTick - var0), this.priority);
    }
}

