/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.waypoints;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.waypoints.Waypoint;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;

public abstract class TrackedWaypoint
implements Waypoint {
    static final Logger LOGGER = LogUtils.getLogger();
    public static StreamCodec<ByteBuf, TrackedWaypoint> STREAM_CODEC = StreamCodec.ofMember(TrackedWaypoint::write, TrackedWaypoint::read);
    protected final Either<UUID, String> identifier;
    private final Waypoint.Icon icon;
    private final Type type;

    TrackedWaypoint(Either<UUID, String> var0, Waypoint.Icon var1, Type var2) {
        this.identifier = var0;
        this.icon = var1;
        this.type = var2;
    }

    public Either<UUID, String> id() {
        return this.identifier;
    }

    public abstract void update(TrackedWaypoint var1);

    public void write(ByteBuf var0) {
        FriendlyByteBuf var1 = new FriendlyByteBuf(var0);
        var1.writeEither(this.identifier, UUIDUtil.STREAM_CODEC, FriendlyByteBuf::writeUtf);
        Waypoint.Icon.STREAM_CODEC.encode(var1, this.icon);
        var1.writeEnum(this.type);
        this.writeContents(var0);
    }

    public abstract void writeContents(ByteBuf var1);

    private static TrackedWaypoint read(ByteBuf var0) {
        FriendlyByteBuf var1 = new FriendlyByteBuf(var0);
        Either<UUID, String> var2 = var1.readEither(UUIDUtil.STREAM_CODEC, FriendlyByteBuf::readUtf);
        Waypoint.Icon var3 = (Waypoint.Icon)Waypoint.Icon.STREAM_CODEC.decode(var1);
        Type var4 = var1.readEnum(Type.class);
        return (TrackedWaypoint)var4.constructor.apply(var2, (Object)var3, (Object)var1);
    }

    public static TrackedWaypoint setPosition(UUID var0, Waypoint.Icon var1, Vec3i var2) {
        return new Vec3iWaypoint(var0, var1, var2);
    }

    public static TrackedWaypoint setChunk(UUID var0, Waypoint.Icon var1, ChunkPos var2) {
        return new ChunkWaypoint(var0, var1, var2);
    }

    public static TrackedWaypoint setAzimuth(UUID var0, Waypoint.Icon var1, float var2) {
        return new AzimuthWaypoint(var0, var1, var2);
    }

    public static TrackedWaypoint empty(UUID var0) {
        return new EmptyWaypoint(var0);
    }

    public abstract double yawAngleToCamera(Level var1, Camera var2);

    public abstract PitchDirection pitchDirectionToCamera(Level var1, Projector var2);

    public abstract double distanceSquared(Entity var1);

    public Waypoint.Icon icon() {
        return this.icon;
    }

    static enum Type {
        EMPTY(EmptyWaypoint::new),
        VEC3I(Vec3iWaypoint::new),
        CHUNK(ChunkWaypoint::new),
        AZIMUTH(AzimuthWaypoint::new);

        final TriFunction<Either<UUID, String>, Waypoint.Icon, FriendlyByteBuf, TrackedWaypoint> constructor;

        private Type(TriFunction var2) {
            this.constructor = var2;
        }
    }

    static class Vec3iWaypoint
    extends TrackedWaypoint {
        private Vec3i vector;

        public Vec3iWaypoint(UUID var0, Waypoint.Icon var1, Vec3i var2) {
            super((Either<UUID, String>)Either.left((Object)var0), var1, Type.VEC3I);
            this.vector = var2;
        }

        public Vec3iWaypoint(Either<UUID, String> var0, Waypoint.Icon var1, FriendlyByteBuf var2) {
            super(var0, var1, Type.VEC3I);
            this.vector = new Vec3i(var2.readVarInt(), var2.readVarInt(), var2.readVarInt());
        }

        @Override
        public void update(TrackedWaypoint var0) {
            if (var0 instanceof Vec3iWaypoint) {
                Vec3iWaypoint var1 = (Vec3iWaypoint)var0;
                this.vector = var1.vector;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", var0.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf var0) {
            VarInt.write(var0, this.vector.getX());
            VarInt.write(var0, this.vector.getY());
            VarInt.write(var0, this.vector.getZ());
        }

        private Vec3 position(Level var02) {
            return this.identifier.left().map(var02::getEntity).map(var0 -> {
                if (var0.blockPosition().distManhattan(this.vector) > 3) {
                    return null;
                }
                return var0.getEyePosition();
            }).orElseGet(() -> Vec3.atCenterOf(this.vector));
        }

        @Override
        public double yawAngleToCamera(Level var0, Camera var1) {
            Vec3 var2 = var1.position().subtract(this.position(var0)).rotateClockwise90();
            float var3 = (float)Mth.atan2(var2.z(), var2.x()) * 57.295776f;
            return Mth.degreesDifference(var1.yaw(), var3);
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level var0, Projector var1) {
            double var4;
            Vec3 var2 = var1.projectPointToScreen(this.position(var0));
            boolean var3 = var2.z > 1.0;
            double d = var4 = var3 ? -var2.y : var2.y;
            if (var4 < -1.0) {
                return PitchDirection.DOWN;
            }
            if (var4 > 1.0) {
                return PitchDirection.UP;
            }
            if (var3) {
                if (var2.y > 0.0) {
                    return PitchDirection.UP;
                }
                if (var2.y < 0.0) {
                    return PitchDirection.DOWN;
                }
            }
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return var0.distanceToSqr(Vec3.atCenterOf(this.vector));
        }
    }

    static class ChunkWaypoint
    extends TrackedWaypoint {
        private ChunkPos chunkPos;

        public ChunkWaypoint(UUID var0, Waypoint.Icon var1, ChunkPos var2) {
            super((Either<UUID, String>)Either.left((Object)var0), var1, Type.CHUNK);
            this.chunkPos = var2;
        }

        public ChunkWaypoint(Either<UUID, String> var0, Waypoint.Icon var1, FriendlyByteBuf var2) {
            super(var0, var1, Type.CHUNK);
            this.chunkPos = new ChunkPos(var2.readVarInt(), var2.readVarInt());
        }

        @Override
        public void update(TrackedWaypoint var0) {
            if (var0 instanceof ChunkWaypoint) {
                ChunkWaypoint var1 = (ChunkWaypoint)var0;
                this.chunkPos = var1.chunkPos;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", var0.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf var0) {
            VarInt.write(var0, this.chunkPos.x);
            VarInt.write(var0, this.chunkPos.z);
        }

        private Vec3 position(double var0) {
            return Vec3.atCenterOf(this.chunkPos.getMiddleBlockPosition((int)var0));
        }

        @Override
        public double yawAngleToCamera(Level var0, Camera var1) {
            Vec3 var2 = var1.position();
            Vec3 var3 = var2.subtract(this.position(var2.y())).rotateClockwise90();
            float var4 = (float)Mth.atan2(var3.z(), var3.x()) * 57.295776f;
            return Mth.degreesDifference(var1.yaw(), var4);
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level var0, Projector var1) {
            double var2 = var1.projectHorizonToScreen();
            if (var2 < -1.0) {
                return PitchDirection.DOWN;
            }
            if (var2 > 1.0) {
                return PitchDirection.UP;
            }
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return var0.distanceToSqr(Vec3.atCenterOf(this.chunkPos.getMiddleBlockPosition(var0.getBlockY())));
        }
    }

    static class AzimuthWaypoint
    extends TrackedWaypoint {
        private float angle;

        public AzimuthWaypoint(UUID var0, Waypoint.Icon var1, float var2) {
            super((Either<UUID, String>)Either.left((Object)var0), var1, Type.AZIMUTH);
            this.angle = var2;
        }

        public AzimuthWaypoint(Either<UUID, String> var0, Waypoint.Icon var1, FriendlyByteBuf var2) {
            super(var0, var1, Type.AZIMUTH);
            this.angle = var2.readFloat();
        }

        @Override
        public void update(TrackedWaypoint var0) {
            if (var0 instanceof AzimuthWaypoint) {
                AzimuthWaypoint var1 = (AzimuthWaypoint)var0;
                this.angle = var1.angle;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", var0.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf var0) {
            var0.writeFloat(this.angle);
        }

        @Override
        public double yawAngleToCamera(Level var0, Camera var1) {
            return Mth.degreesDifference(var1.yaw(), this.angle * 57.295776f);
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level var0, Projector var1) {
            double var2 = var1.projectHorizonToScreen();
            if (var2 < -1.0) {
                return PitchDirection.DOWN;
            }
            if (var2 > 1.0) {
                return PitchDirection.UP;
            }
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return Double.POSITIVE_INFINITY;
        }
    }

    static class EmptyWaypoint
    extends TrackedWaypoint {
        private EmptyWaypoint(Either<UUID, String> var0, Waypoint.Icon var1, FriendlyByteBuf var2) {
            super(var0, var1, Type.EMPTY);
        }

        EmptyWaypoint(UUID var0) {
            super((Either<UUID, String>)Either.left((Object)var0), Waypoint.Icon.NULL, Type.EMPTY);
        }

        @Override
        public void update(TrackedWaypoint var0) {
        }

        @Override
        public void writeContents(ByteBuf var0) {
        }

        @Override
        public double yawAngleToCamera(Level var0, Camera var1) {
            return Double.NaN;
        }

        @Override
        public PitchDirection pitchDirectionToCamera(Level var0, Projector var1) {
            return PitchDirection.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static interface Camera {
        public float yaw();

        public Vec3 position();
    }

    public static interface Projector {
        public Vec3 projectPointToScreen(Vec3 var1);

        public double projectHorizonToScreen();
    }

    public static enum PitchDirection {
        NONE,
        UP,
        DOWN;

    }
}

