/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TrialSpawner;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftTrialSpawnerConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.spawner.TrialSpawnerConfiguration;

public class CraftTrialSpawner
extends CraftBlockEntityState<TrialSpawnerBlockEntity>
implements TrialSpawner {
    private final CraftTrialSpawnerConfiguration normalConfig;
    private final CraftTrialSpawnerConfiguration ominousConfig;

    public CraftTrialSpawner(World world, TrialSpawnerBlockEntity tileEntity) {
        super(world, tileEntity);
        this.normalConfig = new CraftTrialSpawnerConfiguration(tileEntity.getTrialSpawner().normalConfig(), (TrialSpawnerBlockEntity)this.getSnapshot(), this.getRegistryAccess());
        this.ominousConfig = new CraftTrialSpawnerConfiguration(tileEntity.getTrialSpawner().ominousConfig(), (TrialSpawnerBlockEntity)this.getSnapshot(), this.getRegistryAccess());
    }

    protected CraftTrialSpawner(CraftTrialSpawner state, Location location) {
        super(state, location);
        this.normalConfig = state.normalConfig;
        this.ominousConfig = state.ominousConfig;
    }

    public int getCooldownLength() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getTargetCooldownLength();
    }

    public void setCooldownLength(int ticks) {
        TrialSpawner.FullConfig oldConfig = ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config;
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config = new TrialSpawner.FullConfig(oldConfig.normal(), oldConfig.ominous(), ticks, oldConfig.requiredPlayerRange());
    }

    public int getRequiredPlayerRange() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.getRequiredPlayerRange();
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        TrialSpawner.FullConfig oldConfig = ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config;
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.config = new TrialSpawner.FullConfig(oldConfig.normal(), oldConfig.ominous(), oldConfig.targetCooldownLength(), requiredPlayerRange);
    }

    public Collection<Player> getTrackedPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().detectedPlayers) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            players.add((Object)player);
        }
        return players.build();
    }

    public boolean isTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        return this.getTrialData().detectedPlayers.contains(player.getUniqueId());
    }

    public void startTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().detectedPlayers.add(player.getUniqueId());
    }

    public void stopTrackingPlayer(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.getTrialData().detectedPlayers.remove(player.getUniqueId());
    }

    public Collection<Entity> getTrackedEntities() {
        ImmutableSet.Builder entities = ImmutableSet.builder();
        for (UUID uuid : this.getTrialData().currentMobs) {
            Entity entity = Bukkit.getEntity((UUID)uuid);
            if (entity == null) continue;
            entities.add((Object)entity);
        }
        return entities.build();
    }

    public boolean isTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getTrialData().currentMobs.contains(entity.getUniqueId());
    }

    public void startTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().currentMobs.add(entity.getUniqueId());
    }

    public void stopTrackingEntity(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getTrialData().currentMobs.remove(entity.getUniqueId());
    }

    public boolean isOminous() {
        return this.getHandle().getValue(TrialSpawnerBlock.OMINOUS);
    }

    public void setOminous(boolean ominous) {
        ((TrialSpawnerBlockEntity)this.getSnapshot()).trialSpawner.isOminous = ominous;
        if (ominous) {
            this.setData((BlockState)this.getHandle().setValue(TrialSpawnerBlock.OMINOUS, true));
            return;
        }
        this.setData((BlockState)this.getHandle().setValue(TrialSpawnerBlock.OMINOUS, false));
    }

    public TrialSpawnerConfiguration getNormalConfiguration() {
        return this.normalConfig;
    }

    public TrialSpawnerConfiguration getOminousConfiguration() {
        return this.ominousConfig;
    }

    @Override
    protected void applyTo(TrialSpawnerBlockEntity tileEntity) {
        super.applyTo(tileEntity);
        tileEntity.trialSpawner.config = new TrialSpawner.FullConfig(Holder.direct(this.normalConfig.toMinecraft()), Holder.direct(this.ominousConfig.toMinecraft()), this.getCooldownLength(), this.getRequiredPlayerRange());
    }

    private TrialSpawnerStateData getTrialData() {
        return ((TrialSpawnerBlockEntity)this.getSnapshot()).getTrialSpawner().getStateData();
    }

    @Override
    public CraftTrialSpawner copy() {
        return new CraftTrialSpawner(this, null);
    }

    @Override
    public CraftTrialSpawner copy(Location location) {
        return new CraftTrialSpawner(this, location);
    }
}

