/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.boss;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.dimension.end.DragonRespawnAnimation;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;

public class CraftDragonBattle
implements DragonBattle {
    private final EndDragonFight handle;

    public CraftDragonBattle(EndDragonFight handle) {
        this.handle = handle;
    }

    public EnderDragon getEnderDragon() {
        Entity entity = this.handle.level.getEntity(this.handle.dragonUUID);
        return entity != null ? (EnderDragon)entity.getBukkitEntity() : null;
    }

    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.dragonEvent);
    }

    public Location getEndPortalLocation() {
        if (this.handle.portalLocation == null) {
            return null;
        }
        return CraftLocation.toBukkit(this.handle.portalLocation, (World)this.handle.level.getWorld());
    }

    public boolean generateEndPortal(boolean withPortals) {
        if (this.handle.portalLocation != null || this.handle.findExitPortal() != null) {
            return false;
        }
        this.handle.spawnExitPortal(withPortals);
        return true;
    }

    public boolean hasBeenPreviouslyKilled() {
        return this.handle.hasPreviouslyKilledDragon();
    }

    public void setPreviouslyKilled(boolean previouslyKilled) {
        this.handle.previouslyKilled = previouslyKilled;
    }

    public void initiateRespawn() {
        this.handle.tryRespawn();
    }

    public boolean initiateRespawn(Collection<EnderCrystal> list) {
        if (this.hasBeenPreviouslyKilled() && this.getRespawnPhase() == DragonBattle.RespawnPhase.NONE) {
            BlockPattern.BlockPatternMatch shapedetector_shapedetectorcollection;
            if (this.handle.portalLocation == null && (shapedetector_shapedetectorcollection = this.handle.findExitPortal()) == null) {
                this.handle.spawnExitPortal(true);
            }
            list = list != null ? new ArrayList<EnderCrystal>(list) : Collections.emptyList();
            list.removeIf(enderCrystal -> {
                if (enderCrystal == null) {
                    return true;
                }
                World world = enderCrystal.getWorld();
                return !((CraftWorld)world).getHandle().equals(this.handle.level);
            });
            return this.handle.respawnDragon(list.stream().map(enderCrystal -> ((CraftEnderCrystal)enderCrystal).getHandle()).collect(Collectors.toList()));
        }
        return false;
    }

    public DragonBattle.RespawnPhase getRespawnPhase() {
        return this.toBukkitRespawnPhase(this.handle.respawnStage);
    }

    public boolean setRespawnPhase(DragonBattle.RespawnPhase phase) {
        Preconditions.checkArgument((phase != null && phase != DragonBattle.RespawnPhase.NONE ? 1 : 0) != 0, (String)"Invalid respawn phase provided: %s", (Object)phase);
        if (this.handle.respawnStage == null) {
            return false;
        }
        this.handle.setRespawnStage(this.toNMSRespawnPhase(phase));
        return true;
    }

    public void resetCrystals() {
        this.handle.resetSpikeCrystals();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftDragonBattle && ((CraftDragonBattle)obj).handle == this.handle;
    }

    private DragonBattle.RespawnPhase toBukkitRespawnPhase(DragonRespawnAnimation phase) {
        return phase != null ? DragonBattle.RespawnPhase.values()[phase.ordinal()] : DragonBattle.RespawnPhase.NONE;
    }

    private DragonRespawnAnimation toNMSRespawnPhase(DragonBattle.RespawnPhase phase) {
        return phase != DragonBattle.RespawnPhase.NONE ? DragonRespawnAnimation.values()[phase.ordinal()] : null;
    }
}

