/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final CompoundTag data;
    private final org.bukkit.entity.EntityType type;

    private CraftEntitySnapshot(CompoundTag data, org.bukkit.entity.EntityType type) {
        this.data = data;
        this.type = type;
    }

    public org.bukkit.entity.EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        net.minecraft.world.entity.Entity internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity internal = this.createInternal(location.getWorld());
        internal.setPos(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    private net.minecraft.world.entity.Entity createInternal(World world) {
        ServerLevel nms = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity internal = EntityType.loadEntityRecursive(this.data, (Level)nms, EntitySpawnReason.LOAD, Function.identity());
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).create(nms, EntitySpawnReason.LOAD);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        ValueInput val = TagValueInput.create(ProblemReporter.DISCARDING, (HolderLookup.Provider)nms.registryAccess(), this.data);
        internal.load(val);
        return internal;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        TagValueOutput tag = TagValueOutput.createWithContext(ProblemReporter.DISCARDING, entity.getHandle().registryAccess());
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag.buildResult(), entity.getType());
    }

    public static CraftEntitySnapshot create(CompoundTag tag, org.bukkit.entity.EntityType type) {
        if (tag == null || tag.isEmpty() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(CompoundTag tag) {
        org.bukkit.entity.EntityType type = tag.read("id", EntityType.CODEC).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }
}

