/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.util;

import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R5.generator.structure.CraftStructure;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.util.BlockTransformer;
import org.bukkit.util.EntityTransformer;

public class CraftStructureTransformer {
    private CraftLimitedRegion limitedRegion;
    private BlockTransformer[] blockTransformers;
    private EntityTransformer[] entityTransformers;

    public CraftStructureTransformer(AsyncStructureGenerateEvent.Cause cause, WorldGenLevel generatoraccessseed, StructureManager structuremanager, Structure structure, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair) {
        AsyncStructureGenerateEvent event = new AsyncStructureGenerateEvent((World)structuremanager.level.getMinecraftWorld().getWorld(), !Bukkit.isPrimaryThread(), cause, CraftStructure.minecraftToBukkit(structure), new org.bukkit.util.BoundingBox((double)structureboundingbox.minX(), (double)structureboundingbox.minY(), (double)structureboundingbox.minZ(), (double)structureboundingbox.maxX(), (double)structureboundingbox.maxY(), (double)structureboundingbox.maxZ()), chunkcoordintpair.x, chunkcoordintpair.z);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.blockTransformers = (BlockTransformer[])event.getBlockTransformers().values().toArray(BlockTransformer[]::new);
        this.entityTransformers = (EntityTransformer[])event.getEntityTransformers().values().toArray(EntityTransformer[]::new);
        this.limitedRegion = new CraftLimitedRegion(generatoraccessseed, chunkcoordintpair);
    }

    public CraftStructureTransformer(WorldGenLevel generatoraccessseed, ChunkPos chunkcoordintpair, Collection<BlockTransformer> blockTransformers, Collection<EntityTransformer> entityTransformers) {
        this.blockTransformers = (BlockTransformer[])blockTransformers.toArray(BlockTransformer[]::new);
        this.entityTransformers = (EntityTransformer[])entityTransformers.toArray(EntityTransformer[]::new);
        this.limitedRegion = new CraftLimitedRegion(generatoraccessseed, chunkcoordintpair);
    }

    public boolean transformEntity(net.minecraft.world.entity.Entity entity) {
        EntityTransformer[] transformers = this.entityTransformers;
        if (transformers == null || transformers.length == 0) {
            return true;
        }
        CraftLimitedRegion region = this.limitedRegion;
        if (region == null) {
            return true;
        }
        entity.generation = true;
        CraftEntity craftEntity = entity.getBukkitEntity();
        int x = entity.getBlockX();
        int y = entity.getBlockY();
        int z = entity.getBlockZ();
        boolean allowedToSpawn = true;
        for (EntityTransformer transformer : transformers) {
            allowedToSpawn = transformer.transform((LimitedRegion)region, x, y, z, (Entity)craftEntity, allowedToSpawn);
        }
        return allowedToSpawn;
    }

    public boolean canTransformBlocks() {
        return this.blockTransformers != null && this.blockTransformers.length != 0 && this.limitedRegion != null;
    }

    public CraftBlockState transformCraftState(CraftBlockState originalState) {
        BlockTransformer[] transformers = this.blockTransformers;
        if (transformers == null || transformers.length == 0) {
            return originalState;
        }
        CraftLimitedRegion region = this.limitedRegion;
        if (region == null) {
            return originalState;
        }
        originalState.setWorldHandle(region.getHandle());
        BlockPos position = originalState.getPosition();
        CraftBlockState blockState = originalState.copy();
        CraftTransformationState transformationState = new CraftTransformationState(originalState, region.getBlockState(position.getX(), position.getY(), position.getZ()));
        for (BlockTransformer transformer : transformers) {
            blockState = Objects.requireNonNull(transformer.transform((LimitedRegion)region, position.getX(), position.getY(), position.getZ(), (BlockState)blockState, (BlockTransformer.TransformationState)transformationState), "BlockState can't be null");
            transformationState.destroyCopies();
        }
        return blockState;
    }

    public void discard() {
        this.limitedRegion.saveEntities();
        this.limitedRegion.breakLink();
        this.limitedRegion = null;
        this.blockTransformers = null;
        this.entityTransformers = null;
    }

    private static class CraftTransformationState
    implements BlockTransformer.TransformationState {
        private final BlockState original;
        private final BlockState world;
        private BlockState originalCopy;
        private BlockState worldCopy;

        private CraftTransformationState(BlockState original, BlockState world) {
            this.original = original;
            this.world = world;
        }

        public BlockState getOriginal() {
            if (this.originalCopy != null) {
                return this.originalCopy;
            }
            this.originalCopy = this.original.copy();
            return this.originalCopy;
        }

        public BlockState getWorld() {
            if (this.worldCopy != null) {
                return this.worldCopy;
            }
            this.worldCopy = this.world.copy();
            return this.worldCopy;
        }

        private void destroyCopies() {
            this.originalCopy = null;
            this.worldCopy = null;
        }
    }
}

