/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    @ad(reason="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(OptionSet optionset) {
        ac.a();
        try {
            and worldstem;
            Dynamic<?> dynamic;
            Path path = (Path)optionset.valueOf("pidFile");
            if (path != null) {
                Main.a(path);
            }
            p.g();
            if (optionset.has("jfrProfile")) {
                bub.f.a(btz.b);
            }
            amg.a();
            amg.c();
            ag.p();
            Path path1 = Paths.get("server.properties", new String[0]);
            ark dedicatedserversettings = new ark(optionset);
            dedicatedserversettings.b();
            ehq.a(dedicatedserversettings.a().M);
            Path path2 = Paths.get("eula.txt", new String[0]);
            amk eula = new amk(path2);
            if (optionset.has("initSettings")) {
                File configFile = (File)optionset.valueOf("bukkit-settings");
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
                configuration.options().copyDefaults(true);
                configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
                configuration.save(configFile);
                File commandFile = (File)optionset.valueOf("commands-settings");
                YamlConfiguration commandsConfiguration = YamlConfiguration.loadConfiguration((File)commandFile);
                commandsConfiguration.options().copyDefaults(true);
                commandsConfiguration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8)));
                commandsConfiguration.save(commandFile);
                a.info("Initialized '{}' and '{}'", (Object)path1.toAbsolutePath(), (Object)path2.toAbsolutePath());
                return;
            }
            boolean eulaAgreed = Boolean.getBoolean("com.mojang.eula.agree");
            if (eulaAgreed) {
                System.err.println("You have used the Spigot command line EULA agreement flag.");
                System.err.println("By using this setting you are indicating your agreement to Mojang's EULA (https://account.mojang.com/documents/minecraft_eula).");
                System.err.println("If you do not agree to the above EULA please stop your server and remove this flag immediately.");
            }
            if (!eula.a() && !eulaAgreed) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File file = (File)optionset.valueOf("universe");
            amz services = amz.a(new YggdrasilAuthenticationService(Proxy.NO_PROXY), file);
            String s2 = Optional.ofNullable((String)optionset.valueOf("world")).orElse(dedicatedserversettings.a().l);
            fcs convertable = fcs.b(file.toPath());
            fcs.c convertable_conversionsession = convertable.validateAndCreateAccess(s2, ehz.b);
            if (convertable_conversionsession.m()) {
                fct worldinfo;
                try {
                    dynamic = convertable_conversionsession.h();
                    worldinfo = convertable_conversionsession.a(dynamic);
                }
                catch (IOException | ut | va ioexception) {
                    fcs.b convertable_b = convertable_conversionsession.e();
                    a.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    a.info("Attempting to use fallback");
                    try {
                        dynamic = convertable_conversionsession.i();
                        worldinfo = convertable_conversionsession.a(dynamic);
                    }
                    catch (IOException | ut | va ioexception1) {
                        a.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        a.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    convertable_conversionsession.n();
                }
                if (worldinfo.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            Dynamic<?> dynamic1 = dynamic;
            boolean flag = optionset.has("safeMode");
            if (flag) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            awz resourcepackrepository = axc.a(convertable_conversionsession);
            File bukkitDataPackFolder = new File(convertable_conversionsession.a(fcq.j).toFile(), "bukkit");
            if (!bukkitDataPackFolder.exists()) {
                bukkitDataPackFolder.mkdirs();
            }
            File mcMeta = new File(bukkitDataPackFolder, "pack.mcmeta");
            try {
                com.google.common.io.Files.write((CharSequence)("{\n    \"pack\": {\n        \"description\": \"Data pack for resources provided by Bukkit plugins\",\n        \"pack_format\": " + ac.b().a(awd.b) + "\n    }\n}\n"), (File)mcMeta, (Charset)Charsets.UTF_8);
            }
            catch (IOException ex2) {
                throw new RuntimeException("Could not initialize Bukkit datapack", ex2);
            }
            AtomicReference worldLoader = new AtomicReference();
            try {
                anc.c worldloader_c = Main.a(dedicatedserversettings.a(), dynamic1, flag, resourcepackrepository);
                worldstem = (and)ag.c(executor -> anc.a(worldloader_c, worldloader_a -> {
                    ekv worlddimensions;
                    eky worldoptions;
                    dmy worldsettings;
                    worldLoader.set(worldloader_a);
                    jy<ehz> iregistry = worldloader_a.d().f(mn.bv);
                    if (dynamic1 != null) {
                        fcp leveldataanddimensions = fcs.a(dynamic1, worldloader_a.b(), iregistry, worldloader_a.c());
                        return new anc.b<fdd>(leveldataanddimensions.a(), leveldataanddimensions.b().b());
                    }
                    a.info("No existing world data, creating new world");
                    if (optionset.has("demo")) {
                        worldsettings = MinecraftServer.d;
                        worldoptions = eky.b;
                        worlddimensions = euo.a(worldloader_a.c());
                    } else {
                        arj dedicatedserverproperties = dedicatedserversettings.a();
                        worldsettings = new dmy(dedicatedserverproperties.l, dedicatedserverproperties.k, dedicatedserverproperties.t, dedicatedserverproperties.j, false, new dmq(worldloader_a.b().b()), worldloader_a.b());
                        worldoptions = optionset.has("bonusChest") ? dedicatedserverproperties.aa.a(true) : dedicatedserverproperties.aa;
                        worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                    }
                    ekv.b worlddimensions_b = worlddimensions.a(iregistry);
                    Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
                    return new anc.b<fcw>(new fcw(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle), worlddimensions_b.b());
                }, and::new, ag.h(), executor)).get();
            }
            catch (Exception exception) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                return;
            }
            ari ari2 = MinecraftServer.a((Thread thread) -> {
                int port;
                boolean flag2;
                ari dedicatedserver1 = new ari(optionset, (anc.a)worldLoader.get(), (Thread)thread, convertable_conversionsession, resourcepackrepository, worldstem, dedicatedserversettings, bds.a(), services, aun::b);
                boolean bl2 = flag2 = !optionset.has("nogui") && !optionset.nonOptionArguments().contains("nogui");
                if (flag2 && !GraphicsEnvironment.isHeadless()) {
                    dedicatedserver1.bt();
                }
                if (optionset.has("port") && (port = ((Integer)optionset.valueOf("port")).intValue()) > 0) {
                    dedicatedserver1.a(port);
                }
                th.a.b();
                return dedicatedserver1;
            });
        }
        catch (Exception exception1) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)exception1);
        }
    }

    private static void a(Path path) {
        try {
            long i2 = ProcessHandle.current().pid();
            Files.writeString(path, (CharSequence)Long.toString(i2), new OpenOption[0]);
        }
        catch (IOException ioexception) {
            throw new UncheckedIOException(ioexception);
        }
    }

    private static anc.c a(arj dedicatedserverproperties, @Nullable Dynamic<?> dynamic, boolean flag, awz resourcepackrepository) {
        dns worlddataconfiguration;
        boolean flag1;
        if (dynamic != null) {
            dns worlddataconfiguration1 = fcs.a(dynamic);
            flag1 = false;
            worlddataconfiguration = worlddataconfiguration1;
        } else {
            flag1 = true;
            worlddataconfiguration = new dns(dedicatedserverproperties.U, cyf.h);
        }
        anc.d worldloader_d = new anc.d(resourcepackrepository, worlddataconfiguration, flag, flag1);
        return new anc.c(worldloader_d, el.a.b, dedicatedserverproperties.A);
    }

    public static void a(fcs.c convertable_conversionsession, fdd savedata, DataFixer datafixer, boolean flag, BooleanSupplier booleansupplier, jz iregistrycustom, boolean flag1) {
        a.info("Forcing world upgrade! {}", (Object)convertable_conversionsession.f());
        try (bwx worldupgrader = new bwx(convertable_conversionsession, datafixer, savedata, iregistrycustom, flag, flag1);){
            xo ichatbasecomponent = null;
            while (!worldupgrader.b()) {
                int i2;
                xo ichatbasecomponent1 = worldupgrader.h();
                if (ichatbasecomponent != ichatbasecomponent1) {
                    ichatbasecomponent = ichatbasecomponent1;
                    a.info(worldupgrader.h().getString());
                }
                if ((i2 = worldupgrader.e()) > 0) {
                    int j2 = worldupgrader.f() + worldupgrader.g();
                    a.info("{}% completed ({} / {} chunks)...", new Object[]{bcb.d((float)j2 / (float)i2 * 100.0f), j2, i2});
                }
                if (!booleansupplier.getAsBoolean()) {
                    worldupgrader.a();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

