/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final fdo handle;
    private final NamespacedKey key;

    public static LootTable minecraftToBukkit(ame minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftNamespacedKey.fromMinecraft(minecraft));
    }

    public static LootTable minecraftToBukkit(amd<fdo> minecraft) {
        return minecraft == null ? null : Bukkit.getLootTable((NamespacedKey)CraftLootTable.minecraftToBukkitKey(minecraft));
    }

    public static NamespacedKey minecraftToBukkitKey(amd<fdo> minecraft) {
        return minecraft == null ? null : CraftNamespacedKey.fromMinecraft(minecraft.a());
    }

    public static amd<fdo> bukkitToMinecraft(LootTable table) {
        return table == null ? null : CraftLootTable.bukkitKeyToMinecraft(table.getKey());
    }

    public static amd<fdo> bukkitKeyToMinecraft(NamespacedKey key) {
        return key == null ? null : amd.a(mn.bw, CraftNamespacedKey.toMinecraft(key));
    }

    public CraftLootTable(NamespacedKey key, fdo handle) {
        this.handle = handle;
        this.key = key;
    }

    public fdo getHandle() {
        return this.handle;
    }

    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        fdm nmsContext = this.convertContext(context, random);
        ObjectArrayList<dcv> nmsItems = this.handle.a(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (dcv item : nmsItems) {
            if (item.f()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        Preconditions.checkArgument((inventory != null ? 1 : 0) != 0, (Object)"Inventory cannot be null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        fdm nmsContext = this.convertContext(context, random);
        CraftInventory craftInventory = (CraftInventory)inventory;
        bxc handle = craftInventory.getInventory();
        this.getHandle().fillInventory(handle, nmsContext, random.nextLong(), true);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    private fdm convertContext(LootContext context, Random random) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"LootContext cannot be null");
        Location loc = context.getLocation();
        Preconditions.checkArgument((loc.getWorld() != null ? 1 : 0) != 0, (Object)"LootContext.getLocation#getWorld cannot be null");
        aub handle = ((CraftWorld)loc.getWorld()).getHandle();
        fdm.a builder = new fdm.a(handle);
        if (random != null) {
            // empty if block
        }
        this.setMaybe(builder, fgd.f, CraftLocation.toVec3D(loc));
        if (this.getHandle() != fdo.f) {
            if (context.getLootedEntity() != null) {
                bzm nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, fgd.a, nmsLootedEntity);
                this.setMaybe(builder, fgd.c, handle.al().p());
                this.setMaybe(builder, fgd.f, nmsLootedEntity.dv());
            }
            if (context.getKiller() != null) {
                cut nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, fgd.d, nmsKiller);
                this.setMaybe(builder, fgd.c, handle.al().a(nmsKiller));
                this.setMaybe(builder, fgd.b, nmsKiller);
                this.setMaybe(builder, fgd.i, nmsKiller.fI());
            }
        }
        bdo.a nmsBuilder = new bdo.a();
        for (bdn<?> param : this.getHandle().a().a()) {
            nmsBuilder.a(param);
        }
        for (bdn<?> param : this.getHandle().a().b()) {
            if (this.getHandle().a().a().contains(param)) continue;
            nmsBuilder.b(param);
        }
        return builder.a(this.getHandle().a());
    }

    private <T> void setMaybe(fdm.a builder, bdn<T> param, T value) {
        if (this.getHandle().a().a().contains(param) || this.getHandle().a().b().contains(param)) {
            builder.a(param, value);
        }
    }

    public static LootContext convertContext(fdj info) {
        CraftEntity killer;
        fis position = info.c(fgd.f);
        if (position == null) {
            position = info.c(fgd.a).dv();
        }
        Location location = CraftLocation.toBukkit(position, (World)info.d().getWorld());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.a(fgd.d) && (killer = info.c(fgd.d).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((HumanEntity)((CraftHumanEntity)killer));
        }
        if (info.a(fgd.a)) {
            contextBuilder.lootedEntity((Entity)info.c(fgd.a).getBukkitEntity());
        }
        contextBuilder.luck(info.c());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals((Object)this.getKey());
    }
}

