/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R5.util.BlockStateListPopulator;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.RandomSourceWrapper;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.AbstractCow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LargeFireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.SizedFireball;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.potion.PotionType;

public abstract class CraftRegionAccessor
implements RegionAccessor {
    public abstract dnt getHandle();

    public boolean isNormalWorld() {
        return this.getHandle() instanceof aub;
    }

    public Biome getBiome(Location location) {
        return this.getBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Biome getBiome(int x2, int y2, int z2) {
        return CraftBiome.minecraftHolderToBukkit(this.getHandle().getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
    }

    public void setBiome(Location location, Biome biome) {
        this.setBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), biome);
    }

    public void setBiome(int x2, int y2, int z2, Biome biome) {
        Preconditions.checkArgument((biome != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)biome);
        jl<dnx> biomeBase = CraftBiome.bukkitToMinecraftHolder(biome);
        this.setBiome(x2, y2, z2, biomeBase);
    }

    public abstract void setBiome(int var1, int var2, int var3, jl<dnx> var4);

    public BlockState getBlockState(Location location) {
        return this.getBlockState(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockState getBlockState(int x2, int y2, int z2) {
        return CraftBlock.at(this.getHandle(), new jb(x2, y2, z2)).getState();
    }

    public BlockData getBlockData(Location location) {
        return this.getBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockData getBlockData(int x2, int y2, int z2) {
        return CraftBlockData.fromData(this.getData(x2, y2, z2));
    }

    public Material getType(Location location) {
        return this.getType(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Material getType(int x2, int y2, int z2) {
        return CraftBlockType.minecraftToBukkit(this.getData(x2, y2, z2).b());
    }

    private eeb getData(int x2, int y2, int z2) {
        return this.getHandle().a_(new jb(x2, y2, z2));
    }

    public void setBlockData(Location location, BlockData blockData) {
        this.setBlockData(location.getBlockX(), location.getBlockY(), location.getBlockZ(), blockData);
    }

    public void setBlockData(int x2, int y2, int z2, BlockData blockData) {
        dnt world = this.getHandle();
        jb pos = new jb(x2, y2, z2);
        eeb old = this.getHandle().a_(pos);
        CraftBlock.setTypeAndData(world, pos, old, ((CraftBlockData)blockData).getState(), true);
    }

    public void setType(Location location, Material material) {
        this.setType(location.getBlockX(), location.getBlockY(), location.getBlockZ(), material);
    }

    public void setType(int x2, int y2, int z2, Material material) {
        this.setBlockData(x2, y2, z2, material.createBlockData());
    }

    public int getHighestBlockYAt(int x2, int z2) {
        return this.getHighestBlockYAt(x2, z2, HeightMap.MOTION_BLOCKING);
    }

    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    public int getHighestBlockYAt(int x2, int z2, HeightMap heightMap) {
        return this.getHandle().a(CraftHeightMap.toNMS(heightMap), x2, z2);
    }

    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType) {
        jb pos = CraftLocation.toBlockPosition(location);
        return this.generateTree(this.getHandle(), this.getHandle().getMinecraftWorld().n().g(), pos, new RandomSourceWrapper(random), treeType);
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<? super BlockState> consumer) {
        return this.generateTree(location, random, treeType, consumer == null ? null : block -> {
            consumer.accept((BlockState)block);
            return true;
        });
    }

    public boolean generateTree(Location location, Random random, TreeType treeType, Predicate<? super BlockState> predicate) {
        jb pos = CraftLocation.toBlockPosition(location);
        BlockStateListPopulator populator = new BlockStateListPopulator(this.getHandle());
        boolean result = this.generateTree(populator, this.getHandle().getMinecraftWorld().n().g(), pos, new RandomSourceWrapper(random), treeType);
        populator.refreshTiles();
        for (BlockState blockState : populator.getList()) {
            if (predicate != null && !predicate.test((BlockState)blockState)) continue;
            blockState.update(true, true);
        }
        return result;
    }

    public boolean generateTree(dnt access, efz chunkGenerator, jb pos, bck random, TreeType treeType) {
        amd<ems<?, ?>> gen;
        switch (treeType) {
            case BIG_TREE: {
                gen = rw.q;
                break;
            }
            case BIRCH: {
                gen = rw.l;
                break;
            }
            case REDWOOD: {
                gen = rw.n;
                break;
            }
            case TALL_REDWOOD: {
                gen = rw.o;
                break;
            }
            case JUNGLE: {
                gen = rw.s;
                break;
            }
            case SMALL_JUNGLE: {
                gen = rw.r;
                break;
            }
            case COCOA_TREE: {
                gen = rw.p;
                break;
            }
            case JUNGLE_BUSH: {
                gen = rw.y;
                break;
            }
            case RED_MUSHROOM: {
                gen = rw.f;
                break;
            }
            case BROWN_MUSHROOM: {
                gen = rw.e;
                break;
            }
            case SWAMP: {
                gen = rw.x;
                break;
            }
            case ACACIA: {
                gen = rw.m;
                break;
            }
            case DARK_OAK: {
                gen = rw.h;
                break;
            }
            case MEGA_REDWOOD: {
                gen = rw.t;
                break;
            }
            case MEGA_PINE: {
                gen = rw.u;
                break;
            }
            case TALL_BIRCH: {
                gen = rw.v;
                break;
            }
            case CHORUS_PLANT: {
                drf cfr_ignored_0 = (drf)dqb.lb;
                drf.a(access, pos, random, 8);
                return true;
            }
            case CRIMSON_FUNGUS: {
                gen = rw.b;
                break;
            }
            case WARPED_FUNGUS: {
                gen = rw.d;
                break;
            }
            case AZALEA: {
                gen = rw.z;
                break;
            }
            case MANGROVE: {
                gen = rw.A;
                break;
            }
            case TALL_MANGROVE: {
                gen = rw.B;
                break;
            }
            case CHERRY: {
                gen = rw.C;
                break;
            }
            case PALE_OAK: {
                gen = rw.i;
                break;
            }
            case PALE_OAK_CREAKING: {
                gen = rw.k;
                break;
            }
            default: {
                gen = rw.g;
            }
        }
        jl holder = access.K_().f(mn.aP).a(gen).orElse(null);
        return holder != null ? ((ems)holder.a()).a(access, chunkGenerator, random, pos) : false;
    }

    public Entity spawnEntity(Location location, EntityType entityType) {
        return this.spawn(location, entityType.getEntityClass());
    }

    public Entity spawnEntity(Location loc, EntityType type, boolean randomizeData) {
        return this.spawn(loc, type.getEntityClass(), null, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity != null && bukkitEntity instanceof LivingEntity && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add((LivingEntity)bukkitEntity);
            }
        });
        return list;
    }

    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList list = new ArrayList();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class bukkitClass = bukkitEntity.getClass();
            if (clazz.isAssignableFrom(bukkitClass) && (!this.isNormalWorld() || bukkitEntity.isValid())) {
                list.add(bukkitEntity);
            }
        });
        return list;
    }

    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        this.getNMSEntities().forEach(entity -> {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (bukkitEntity == null) {
                return;
            }
            Class bukkitClass = bukkitEntity.getClass();
            for (Class clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                if (this.isNormalWorld() && !bukkitEntity.isValid()) break;
                list.add(bukkitEntity);
                break;
            }
        });
        return list;
    }

    public abstract Iterable<bzm> getNMSEntities();

    public <T extends Entity> T createEntity(Location location, Class<T> clazz) throws IllegalArgumentException {
        bzm entity = this.createEntity(location, clazz, true);
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        return (T)entity.getBukkitEntity();
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, null, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, boolean randomizeData, Consumer<? super T> function) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, CreatureSpawnEvent.SpawnReason.CUSTOM, randomizeData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.spawn(location, clazz, function, reason, true);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<? super T> function, CreatureSpawnEvent.SpawnReason reason, boolean randomizeData) throws IllegalArgumentException {
        bzm entity = this.createEntity(location, clazz, randomizeData);
        return this.addEntity(entity, reason, function, randomizeData);
    }

    public <T extends Entity> T addEntity(T entity) {
        Preconditions.checkArgument((!entity.isInWorld() ? 1 : 0) != 0, (Object)"Entity has already been added to a world");
        bzm nmsEntity = ((CraftEntity)entity).getHandle();
        if (nmsEntity.ai() != this.getHandle().a()) {
            nmsEntity = nmsEntity.b(new fbl(this.getHandle().a(), nmsEntity, fbl.a));
        }
        this.addEntityWithPassengers(nmsEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (T)nmsEntity.getBukkitEntity();
    }

    public <T extends Entity> T addEntity(bzm entity, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        return this.addEntity(entity, reason, null, true);
    }

    public <T extends Entity> T addEntity(bzm entity, CreatureSpawnEvent.SpawnReason reason, Consumer<? super T> function, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Cannot spawn null entity");
        if (randomizeData && entity instanceof cao) {
            ((cao)entity).a((dnl)this.getHandle(), this.getHandle().d_(entity.dx()), bzu.n, (cbe)null);
        }
        if (!this.isNormalWorld()) {
            entity.generation = true;
        }
        if (function != null) {
            function.accept(entity.getBukkitEntity());
        }
        this.addEntityToWorld(entity, reason);
        return (T)entity.getBukkitEntity();
    }

    public abstract void addEntityToWorld(bzm var1, CreatureSpawnEvent.SpawnReason var2);

    public abstract void addEntityWithPassengers(bzm var1, CreatureSpawnEvent.SpawnReason var2);

    public bzm makeEntity(Location location, Class<? extends Entity> clazz) throws IllegalArgumentException {
        return this.createEntity(location, clazz, true);
    }

    public bzm createEntity(Location location, Class<? extends Entity> clazz, boolean randomizeData) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Entity class cannot be null");
        Consumer<bzm> runOld = other -> {};
        if (clazz == AbstractArrow.class) {
            clazz = Arrow.class;
        } else if (clazz == AbstractHorse.class) {
            clazz = Horse.class;
        } else if (clazz == AbstractCow.class) {
            clazz = Cow.class;
        } else if (clazz == Fireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == Minecart.class) {
            clazz = RideableMinecart.class;
        } else if (clazz == SizedFireball.class) {
            clazz = LargeFireball.class;
        } else if (clazz == TippedArrow.class) {
            clazz = Arrow.class;
            runOld = other -> ((Arrow)other.getBukkitEntity()).setBasePotionType(PotionType.WATER);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(clazz);
        if (entityTypeData == null || entityTypeData.spawnFunction() == null) {
            if (CraftEntity.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(String.format("Cannot spawn an entity from its CraftBukkit implementation class '%s' use the Bukkit class instead. You can get the Bukkit representation via Entity#getType()#getEntityClass()", clazz.getName()));
            }
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
        }
        if (!entityTypeData.entityType().isEnabledByFeature((World)this.getHandle().getMinecraftWorld().getWorld())) {
            throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName() + " because it is not an enabled feature");
        }
        bzm entity = (bzm)entityTypeData.spawnFunction().apply(new CraftEntityTypes.SpawnData(this.getHandle(), location, randomizeData, this.isNormalWorld()));
        if (entity != null) {
            runOld.accept(entity);
            return entity;
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }
}

