/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemType;
import org.bukkit.entity.EntityType;

public enum CraftStatistic {
    DAMAGE_DEALT(azj.H),
    DAMAGE_TAKEN(azj.K),
    DEATHS(azj.O),
    MOB_KILLS(azj.P),
    PLAYER_KILLS(azj.R),
    FISH_CAUGHT(azj.S),
    ANIMALS_BRED(azj.Q),
    LEAVE_GAME(azj.j),
    JUMP(azj.F),
    DROP_COUNT(azj.G),
    DROP(ame.b("dropped")),
    PICKUP(ame.b("picked_up")),
    PLAY_ONE_MINUTE(azj.k),
    TOTAL_WORLD_TIME(azj.l),
    WALK_ONE_CM(azj.p),
    WALK_ON_WATER_ONE_CM(azj.s),
    FALL_ONE_CM(azj.t),
    SNEAK_TIME(azj.o),
    CLIMB_ONE_CM(azj.u),
    FLY_ONE_CM(azj.v),
    WALK_UNDER_WATER_ONE_CM(azj.w),
    MINECART_ONE_CM(azj.x),
    BOAT_ONE_CM(azj.y),
    PIG_ONE_CM(azj.z),
    HAPPY_GHAST_ONE_CM(azj.A),
    HORSE_ONE_CM(azj.B),
    SPRINT_ONE_CM(azj.r),
    CROUCH_ONE_CM(azj.q),
    AVIATE_ONE_CM(azj.C),
    MINE_BLOCK(ame.b("mined")),
    USE_ITEM(ame.b("used")),
    BREAK_ITEM(ame.b("broken")),
    CRAFT_ITEM(ame.b("crafted")),
    KILL_ENTITY(ame.b("killed")),
    ENTITY_KILLED_BY(ame.b("killed_by")),
    TIME_SINCE_DEATH(azj.m),
    TALKED_TO_VILLAGER(azj.T),
    TRADED_WITH_VILLAGER(azj.U),
    CAKE_SLICES_EATEN(azj.V),
    CAULDRON_FILLED(azj.W),
    CAULDRON_USED(azj.X),
    ARMOR_CLEANED(azj.Y),
    BANNER_CLEANED(azj.Z),
    BREWINGSTAND_INTERACTION(azj.ab),
    BEACON_INTERACTION(azj.ac),
    DROPPER_INSPECTED(azj.ad),
    HOPPER_INSPECTED(azj.ae),
    DISPENSER_INSPECTED(azj.af),
    NOTEBLOCK_PLAYED(azj.ag),
    NOTEBLOCK_TUNED(azj.ah),
    FLOWER_POTTED(azj.ai),
    TRAPPED_CHEST_TRIGGERED(azj.aj),
    ENDERCHEST_OPENED(azj.ak),
    ITEM_ENCHANTED(azj.al),
    RECORD_PLAYED(azj.am),
    FURNACE_INTERACTION(azj.an),
    CRAFTING_TABLE_INTERACTION(azj.ao),
    CHEST_OPENED(azj.ap),
    SLEEP_IN_BED(azj.aq),
    SHULKER_BOX_OPENED(azj.ar),
    TIME_SINCE_REST(azj.n),
    SWIM_ONE_CM(azj.D),
    DAMAGE_DEALT_ABSORBED(azj.I),
    DAMAGE_DEALT_RESISTED(azj.J),
    DAMAGE_BLOCKED_BY_SHIELD(azj.L),
    DAMAGE_ABSORBED(azj.M),
    DAMAGE_RESISTED(azj.N),
    CLEAN_SHULKER_BOX(azj.aa),
    OPEN_BARREL(azj.as),
    INTERACT_WITH_BLAST_FURNACE(azj.at),
    INTERACT_WITH_SMOKER(azj.au),
    INTERACT_WITH_LECTERN(azj.av),
    INTERACT_WITH_CAMPFIRE(azj.aw),
    INTERACT_WITH_CARTOGRAPHY_TABLE(azj.ax),
    INTERACT_WITH_LOOM(azj.ay),
    INTERACT_WITH_STONECUTTER(azj.az),
    BELL_RING(azj.aA),
    RAID_TRIGGER(azj.aB),
    RAID_WIN(azj.aC),
    INTERACT_WITH_ANVIL(azj.aD),
    INTERACT_WITH_GRINDSTONE(azj.aE),
    TARGET_HIT(azj.aF),
    INTERACT_WITH_SMITHING_TABLE(azj.aG),
    STRIDER_ONE_CM(azj.E);

    private final ame minecraftKey;
    private final Statistic bukkit;
    private static final BiMap<ame, Statistic> statistics;

    private CraftStatistic(ame minecraftKey) {
        this.minecraftKey = minecraftKey;
        this.bukkit = Statistic.valueOf((String)this.name());
        Preconditions.checkState((this.bukkit != null ? 1 : 0) != 0, (String)"Bukkit statistic %s does not exist", (Object)this.name());
    }

    public static Statistic getBukkitStatistic(azg<?> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        jy<?> statRegistry = statistic.a().b();
        ame nmsKey = mm.v.b(statistic.a());
        if (statRegistry == mm.k) {
            nmsKey = (ame)statistic.b();
        }
        return (Statistic)statistics.get((Object)nmsKey);
    }

    public static azg getNMSStatistic(Statistic bukkit) {
        Preconditions.checkArgument((bukkit.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"This method only accepts untyped statistics");
        azg<ame> nms = azj.i.b((ame)statistics.inverse().get((Object)bukkit));
        Preconditions.checkArgument((nms != null ? 1 : 0) != 0, (String)"NMS Statistic %s does not exist", (Object)bukkit);
        return nms;
    }

    public static azg getMaterialStatistic(Statistic stat, Material material) {
        Statistic.Type type = stat.getType();
        switch (type) {
            case BLOCK: {
                Preconditions.checkArgument((boolean)material.isBlock(), (String)"statistic type is BLOCK but got non-block Material, %s", (Object)material);
                if (stat != Statistic.MINE_BLOCK) break;
                return azj.a.b(CraftBlockType.bukkitToMinecraft(material));
            }
            case ITEM: {
                Preconditions.checkArgument((boolean)material.isItem(), (String)"statistic type is ITEM but got non-item Material, %s", (Object)material);
                if (stat == Statistic.CRAFT_ITEM) {
                    return azj.b.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.USE_ITEM) {
                    return azj.c.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.BREAK_ITEM) {
                    return azj.d.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat == Statistic.PICKUP) {
                    return azj.e.b(CraftItemType.bukkitToMinecraft(material));
                }
                if (stat != Statistic.DROP) break;
                return azj.f.b(CraftItemType.bukkitToMinecraft(material));
            }
            default: {
                throw new IllegalArgumentException("statistic type must be either BLOCK or ITEM, given " + String.valueOf(type));
            }
        }
        throw new IllegalArgumentException("Unknwon material statistic " + String.valueOf(stat));
    }

    public static azg getEntityStatistic(Statistic stat, EntityType entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        if (entity.getName() != null) {
            bzv<?> nmsEntity = CraftEntityType.bukkitToMinecraft(entity);
            if (stat == Statistic.KILL_ENTITY) {
                return azj.g.b(nmsEntity);
            }
            if (stat == Statistic.ENTITY_KILLED_BY) {
                return azj.h.b(nmsEntity);
            }
        }
        return null;
    }

    public static EntityType getEntityTypeFromStatistic(azg<bzv<?>> statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"NMS Statistic cannot be null");
        return CraftEntityType.minecraftToBukkit(statistic.b());
    }

    public static Material getMaterialFromStatistic(azg<?> statistic) {
        Object obj = statistic.b();
        if (obj instanceof dcr) {
            dcr statisticItemValue = (dcr)obj;
            return CraftItemType.minecraftToBukkit(statisticItemValue);
        }
        obj = statistic.b();
        if (obj instanceof dpz) {
            dpz statisticBlockValue = (dpz)obj;
            return CraftBlockType.minecraftToBukkit(statisticBlockValue);
        }
        return null;
    }

    public static void incrementStatistic(azf manager, Statistic statistic, auc player) {
        CraftStatistic.incrementStatistic(manager, statistic, 1, player);
    }

    public static void decrementStatistic(azf manager, Statistic statistic, auc player) {
        CraftStatistic.decrementStatistic(manager, statistic, 1, player);
    }

    public static int getStatistic(azf manager, Statistic statistic) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        return manager.a(CraftStatistic.getNMSStatistic(statistic));
    }

    public static void incrementStatistic(azf manager, Statistic statistic, int amount, auc player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) + amount, player);
    }

    public static void decrementStatistic(azf manager, Statistic statistic, int amount, auc player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, CraftStatistic.getStatistic(manager, statistic) - amount, player);
    }

    public static void setStatistic(azf manager, Statistic statistic, int newValue, auc player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.UNTYPED ? 1 : 0) != 0, (Object)"Must supply additional parameter for this statistic");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        azg nmsStatistic = CraftStatistic.getNMSStatistic(statistic);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.y().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(azf manager, Statistic statistic, Material material, auc player) {
        CraftStatistic.incrementStatistic(manager, statistic, material, 1, player);
    }

    public static void decrementStatistic(azf manager, Statistic statistic, Material material, auc player) {
        CraftStatistic.decrementStatistic(manager, statistic, material, 1, player);
    }

    public static int getStatistic(azf manager, Statistic statistic, Material material) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        azg nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(azf manager, Statistic statistic, Material material, int amount, auc player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) + amount, player);
    }

    public static void decrementStatistic(azf manager, Statistic statistic, Material material, int amount, auc player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, material, CraftStatistic.getStatistic(manager, statistic, material) - amount, player);
    }

    public static void setStatistic(azf manager, Statistic statistic, Material material, int newValue, auc player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM ? 1 : 0) != 0, (Object)"This statistic does not take a Material parameter");
        azg nmsStatistic = CraftStatistic.getMaterialStatistic(statistic, material);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied Material %s does not have a corresponding statistic", (Object)material);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.y().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    public static void incrementStatistic(azf manager, Statistic statistic, EntityType entityType, auc player) {
        CraftStatistic.incrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static void decrementStatistic(azf manager, Statistic statistic, EntityType entityType, auc player) {
        CraftStatistic.decrementStatistic(manager, statistic, entityType, 1, player);
    }

    public static int getStatistic(azf manager, Statistic statistic, EntityType entityType) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        azg nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        return manager.a(nmsStatistic);
    }

    public static void incrementStatistic(azf manager, Statistic statistic, EntityType entityType, int amount, auc player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) + amount, player);
    }

    public static void decrementStatistic(azf manager, Statistic statistic, EntityType entityType, int amount, auc player) {
        Preconditions.checkArgument((amount > 0 ? 1 : 0) != 0, (Object)"Amount must be greater than 0");
        CraftStatistic.setStatistic(manager, statistic, entityType, CraftStatistic.getStatistic(manager, statistic, entityType) - amount, player);
    }

    public static void setStatistic(azf manager, Statistic statistic, EntityType entityType, int newValue, auc player) {
        Preconditions.checkArgument((statistic != null ? 1 : 0) != 0, (Object)"Statistic cannot be null");
        Preconditions.checkArgument((entityType != null ? 1 : 0) != 0, (Object)"EntityType cannot be null");
        Preconditions.checkArgument((newValue >= 0 ? 1 : 0) != 0, (Object)"Value must be greater than or equal to 0");
        Preconditions.checkArgument((statistic.getType() == Statistic.Type.ENTITY ? 1 : 0) != 0, (Object)"This statistic does not take an EntityType parameter");
        azg nmsStatistic = CraftStatistic.getEntityStatistic(statistic, entityType);
        Preconditions.checkArgument((nmsStatistic != null ? 1 : 0) != 0, (String)"The supplied EntityType %s does not have a corresponding statistic", (Object)entityType);
        manager.a(null, nmsStatistic, newValue);
        if (player != null) {
            player.y().getCraftServer().getScoreboardManager().forAllObjectives(nmsStatistic, player, score -> score.a(newValue));
        }
    }

    static {
        ImmutableBiMap.Builder statisticBuilder = ImmutableBiMap.builder();
        for (CraftStatistic statistic : CraftStatistic.values()) {
            statisticBuilder.put((Object)statistic.minecraftKey, (Object)statistic.bukkit);
        }
        statistics = statisticBuilder.build();
    }
}

