/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.banner.Pattern;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.banner.CraftPatternType;

public class CraftBanner
extends CraftBlockEntityState<ean>
implements Banner {
    private DyeColor base;
    private List<Pattern> patterns;

    public CraftBanner(World world, ean tileEntity) {
        super(world, tileEntity);
    }

    protected CraftBanner(CraftBanner state, Location location) {
        super(state, location);
        this.base = state.getBaseColor();
        this.patterns = state.getPatterns();
    }

    @Override
    public void load(ean banner) {
        super.load(banner);
        this.base = DyeColor.getByWoolData((byte)((byte)((doq)this.data.b()).b().a()));
        this.patterns = new ArrayList<Pattern>();
        if (banner.b() != null) {
            for (int i2 = 0; i2 < banner.b().b().size(); ++i2) {
                eap.b p2 = banner.b().b().get(i2);
                this.patterns.add(new Pattern(DyeColor.getByWoolData((byte)((byte)p2.c().a())), CraftPatternType.minecraftHolderToBukkit(p2.b())));
            }
        }
    }

    public DyeColor getBaseColor() {
        return this.base;
    }

    public void setBaseColor(DyeColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.base = color;
    }

    public List<Pattern> getPatterns() {
        return new ArrayList<Pattern>(this.patterns);
    }

    public void setPatterns(List<Pattern> patterns) {
        this.patterns = new ArrayList<Pattern>(patterns);
    }

    public void addPattern(Pattern pattern) {
        this.patterns.add(pattern);
    }

    public Pattern getPattern(int i2) {
        return this.patterns.get(i2);
    }

    public Pattern removePattern(int i2) {
        return this.patterns.remove(i2);
    }

    public void setPattern(int i2, Pattern pattern) {
        this.patterns.set(i2, pattern);
    }

    public int numberOfPatterns() {
        return this.patterns.size();
    }

    @Override
    protected void applyTo(ean banner) {
        super.applyTo(banner);
        banner.d = dbt.a(this.base.getWoolData());
        ArrayList<eap.b> newPatterns = new ArrayList<eap.b>();
        for (Pattern p2 : this.patterns) {
            newPatterns.add(new eap.b(CraftPatternType.bukkitToMinecraftHolder(p2.getPattern()), dbt.a(p2.getColor().getWoolData())));
        }
        banner.setPatterns(new eap(newPatterns));
    }

    @Override
    public CraftBanner copy() {
        return new CraftBanner(this, null);
    }

    @Override
    public CraftBanner copy(Location location) {
        return new CraftBanner(this, location);
    }
}

