/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftVoxelShape;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.bukkit.util.VoxelShape;

public class CraftBlock
implements Block {
    private final dmv world;
    private final jb position;

    public CraftBlock(dmv world, jb position) {
        this.world = world;
        this.position = position.j();
    }

    public static CraftBlock at(dmv world, jb position) {
        return new CraftBlock(world, position);
    }

    public eeb getNMS() {
        return this.world.a_(this.position);
    }

    public jb getPosition() {
        return this.position;
    }

    public dmv getHandle() {
        return this.world;
    }

    public World getWorld() {
        return this.world.getMinecraftWorld().getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public Location getLocation() {
        return CraftLocation.toBukkit(this.position, this.getWorld());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX((double)this.position.u());
            loc.setY((double)this.position.v());
            loc.setZ((double)this.position.w());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.getX(), this.getY(), this.getZ());
    }

    public int getX() {
        return this.position.u();
    }

    public int getY() {
        return this.position.v();
    }

    public int getZ() {
        return this.position.w();
    }

    public Chunk getChunk() {
        return this.getWorld().getChunkAt((Block)this);
    }

    public void setData(byte data) {
        this.setData(data, 3);
    }

    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.setData(data, 3);
        } else {
            this.setData(data, 2);
        }
    }

    private void setData(byte data, int flag) {
        this.world.a(this.position, CraftMagicNumbers.getBlock(this.getType(), data), flag);
    }

    public byte getData() {
        eeb blockData = this.world.a_(this.position);
        return CraftMagicNumbers.toLegacyData(blockData);
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getNMS());
    }

    public void setType(Material type) {
        this.setType(type, true);
    }

    public void setType(Material type, boolean applyPhysics) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        this.setBlockData(type.createBlockData(), applyPhysics);
    }

    public void setBlockData(BlockData data) {
        this.setBlockData(data, true);
    }

    public void setBlockData(BlockData data, boolean applyPhysics) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        this.setTypeAndData(((CraftBlockData)data).getState(), applyPhysics);
    }

    boolean setTypeAndData(eeb blockData, boolean applyPhysics) {
        return CraftBlock.setTypeAndData(this.world, this.position, this.getNMS(), blockData, applyPhysics);
    }

    public static boolean setTypeAndData(dmv world, jb position, eeb old, eeb blockData, boolean applyPhysics) {
        if (old.x() && blockData.b() != old.b()) {
            if (world instanceof dmu) {
                ((dmu)world).o(position);
            } else {
                world.a(position, dqb.a.m(), 0);
            }
        }
        if (applyPhysics) {
            return world.a(position, blockData, 3);
        }
        boolean success = world.a(position, blockData, 530);
        if (success && world instanceof dmu) {
            world.getMinecraftWorld().a(position, old, blockData, 3);
        }
        return success;
    }

    public Material getType() {
        return CraftBlockType.minecraftToBukkit(this.world.a_(this.position).b());
    }

    public byte getLightLevel() {
        return (byte)this.world.getMinecraftWorld().C(this.position);
    }

    public byte getLightFromSky() {
        return (byte)this.world.a(dnd.a, this.position);
    }

    public byte getLightFromBlocks() {
        return (byte)this.world.a(dnd.b, this.position);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    public BlockFace getFace(Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{pos=" + String.valueOf(this.position) + ",type=" + String.valueOf(this.getType()) + ",data=" + String.valueOf(this.getNMS()) + ",fluid=" + String.valueOf(this.world.b_(this.position)) + "}";
    }

    public static BlockFace notchToBlockFace(jh notch) {
        if (notch == null) {
            return BlockFace.SELF;
        }
        switch (notch) {
            case a: {
                return BlockFace.DOWN;
            }
            case b: {
                return BlockFace.UP;
            }
            case c: {
                return BlockFace.NORTH;
            }
            case d: {
                return BlockFace.SOUTH;
            }
            case e: {
                return BlockFace.WEST;
            }
            case f: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static jh blockFaceToNotch(BlockFace face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case DOWN: {
                return jh.a;
            }
            case UP: {
                return jh.b;
            }
            case NORTH: {
                return jh.c;
            }
            case SOUTH: {
                return jh.d;
            }
            case WEST: {
                return jh.e;
            }
            case EAST: {
                return jh.f;
            }
        }
        return null;
    }

    public BlockState getState() {
        return CraftBlockStates.getBlockState(this);
    }

    public Biome getBiome() {
        return this.getWorld().getBiome(this.getX(), this.getY(), this.getZ());
    }

    public void setBiome(Biome bio2) {
        this.getWorld().setBiome(this.getX(), this.getY(), this.getZ(), bio2);
    }

    public double getTemperature() {
        return this.world.v(this.position).a().f(this.position, this.world.Q());
    }

    public double getHumidity() {
        return this.getWorld().getHumidity(this.getX(), this.getY(), this.getZ());
    }

    public boolean isBlockPowered() {
        return this.world.getMinecraftWorld().e_(this.position) > 0;
    }

    public boolean isBlockIndirectlyPowered() {
        return this.world.getMinecraftWorld().E(this.position);
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o2;
        return this.position.equals(other.position) && this.getWorld().equals((Object)other.getWorld());
    }

    public int hashCode() {
        return this.position.hashCode() ^ this.getWorld().hashCode();
    }

    public boolean isBlockFacePowered(BlockFace face) {
        return this.world.getMinecraftWorld().b(this.position, CraftBlock.blockFaceToNotch(face));
    }

    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.world.getMinecraftWorld().c(this.position, CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    public int getBlockPower(BlockFace face) {
        int power = 0;
        aub world = this.world.getMinecraftWorld();
        int x2 = this.getX();
        int y2 = this.getY();
        int z2 = this.getZ();
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.b(new jb(x2, y2 - 1, z2), jh.a)) {
            power = CraftBlock.getPower(power, world.a_(new jb(x2, y2 - 1, z2)));
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.b(new jb(x2, y2 + 1, z2), jh.b)) {
            power = CraftBlock.getPower(power, world.a_(new jb(x2, y2 + 1, z2)));
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.b(new jb(x2 + 1, y2, z2), jh.f)) {
            power = CraftBlock.getPower(power, world.a_(new jb(x2 + 1, y2, z2)));
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.b(new jb(x2 - 1, y2, z2), jh.e)) {
            power = CraftBlock.getPower(power, world.a_(new jb(x2 - 1, y2, z2)));
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.b(new jb(x2, y2, z2 - 1), jh.c)) {
            power = CraftBlock.getPower(power, world.a_(new jb(x2, y2, z2 - 1)));
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.b(new jb(x2, y2, z2 + 1), jh.d)) {
            power = CraftBlock.getPower(power, world.a_(new jb(x2, y2, z2 + 1)));
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    private static int getPower(int i2, eeb iblockdata) {
        if (!iblockdata.a(dqb.cH)) {
            return i2;
        }
        int j2 = iblockdata.c(dwj.f);
        return j2 > i2 ? j2 : i2;
    }

    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    public boolean isEmpty() {
        return this.getNMS().l();
    }

    public boolean isLiquid() {
        return this.getNMS().n();
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getNMS().r().ordinal());
    }

    public boolean breakNaturally() {
        return this.breakNaturally(null);
    }

    public boolean breakNaturally(ItemStack item) {
        eeb iblockdata = this.getNMS();
        dpz block = iblockdata.b();
        dcv nmsItem = CraftItemStack.asNMSCopy(item);
        boolean result = false;
        if (block != dqb.a && (item == null || !iblockdata.C() || nmsItem.b(iblockdata))) {
            dpz.a(iblockdata, (dmu)this.world.getMinecraftWorld(), this.position, this.world.c_(this.position), null, nmsItem);
            result = true;
        }
        return this.world.a(this.position, dqb.a.m(), 3) && result;
    }

    public boolean applyBoneMeal(BlockFace face) {
        jh direction = CraftBlock.blockFaceToNotch(face);
        BlockFertilizeEvent event = null;
        aub world = this.getCraftWorld().getHandle();
        dgq context = new dgq(world, null, bxi.a, dcz.sX.m(), new fio(fis.c, direction, this.getPosition(), false));
        world.captureTreeGeneration = true;
        bxj result = dbf.applyBonemeal(context);
        world.captureTreeGeneration = false;
        if (world.capturedBlockStates.size() > 0) {
            TreeType treeType = dww.treeType;
            dww.treeType = null;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                structureEvent = new StructureGrowEvent(this.getLocation(), treeType, true, null, blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            event = new BlockFertilizeEvent((Block)CraftBlock.at(world, this.getPosition()), null, blocks);
            event.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                for (BlockState blockstate : blocks) {
                    blockstate.update(true);
                }
            }
        }
        return result == bxj.a && (event == null || !event.isCancelled());
    }

    public Collection<ItemStack> getDrops() {
        return this.getDrops(null);
    }

    public Collection<ItemStack> getDrops(ItemStack item) {
        return this.getDrops(item, null);
    }

    public Collection<ItemStack> getDrops(ItemStack item, Entity entity) {
        eeb iblockdata = this.getNMS();
        dcv nms = CraftItemStack.asNMSCopy(item);
        if (item == null || CraftBlockData.isPreferredTool(iblockdata, nms)) {
            return dpz.a(iblockdata, this.world.getMinecraftWorld(), this.position, this.world.c_(this.position), entity == null ? null : ((CraftEntity)entity).getHandle(), nms).stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isPreferredTool(ItemStack item) {
        eeb iblockdata = this.getNMS();
        dcv nms = CraftItemStack.asNMSCopy(item);
        return CraftBlockData.isPreferredTool(iblockdata, nms);
    }

    public float getBreakSpeed(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        return this.getNMS().a(((CraftPlayer)player).getHandle(), this.world, this.position);
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isPassable() {
        return this.getNMS().g(this.world, this.position).c();
    }

    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((boolean)this.getWorld().equals((Object)start.getWorld()), (Object)"Location start cannot be a different world");
        start.checkFinite();
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) must be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir2 = direction.clone().normalize().multiply(maxDistance);
        fis startPos = CraftLocation.toVec3D(start);
        fis endPos = startPos.b(dir2.getX(), dir2.getY(), dir2.getZ());
        fio nmsHitResult = this.world.clip(new dmb(startPos, endPos, dmb.a.b, CraftFluidCollisionMode.toNMS(fluidCollisionMode), fix.a()), this.position);
        return CraftRayTraceResult.fromNMS(this.getWorld(), nmsHitResult);
    }

    public BoundingBox getBoundingBox() {
        fjm shape = this.getNMS().f(this.world, this.position);
        if (shape.c()) {
            return new BoundingBox();
        }
        fin aabb = shape.a();
        return new BoundingBox((double)this.getX() + aabb.a, (double)this.getY() + aabb.b, (double)this.getZ() + aabb.c, (double)this.getX() + aabb.d, (double)this.getY() + aabb.e, (double)this.getZ() + aabb.f);
    }

    public VoxelShape getCollisionShape() {
        fjm shape = this.getNMS().g(this.world, this.position);
        return new CraftVoxelShape(shape);
    }

    public boolean canPlace(BlockData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        eeb iblockdata = ((CraftBlockData)data).getState();
        aub world = this.world.getMinecraftWorld();
        return iblockdata.a((dmx)world, this.position);
    }

    public String getTranslationKey() {
        return this.getNMS().b().v();
    }
}

