/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block;

import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftBlockEntityState<T extends eaz>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, ((eaz)tileEntity).aA_(), ((eaz)tileEntity).m());
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    protected CraftBlockEntityState(CraftBlockEntityState<T> state, Location location) {
        super(state, location);
        this.tileEntity = this.createSnapshot(state.snapshot);
        this.snapshot = this.tileEntity;
        this.loadData(state.getSnapshotNBT());
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    protected jz getRegistryAccess() {
        dmv worldHandle = this.getWorldHandle();
        return worldHandle != null ? worldHandle.K_() : MinecraftServer.getDefaultRegistryAccess();
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        ui nbtTagCompound = ((eaz)tileEntity).b(this.getRegistryAccess());
        eaz snapshot = eaz.a(this.getPosition(), this.getHandle(), nbtTagCompound, this.getRegistryAccess());
        return (T)snapshot;
    }

    public Set<kp<?>> applyComponents(kn datacomponentmap, ko datacomponentpatch) {
        Set<kp<?>> result = ((eaz)this.snapshot).applyComponentsSet(datacomponentmap, datacomponentpatch);
        this.load(this.snapshot);
        return result;
    }

    public kn collectComponents() {
        return ((eaz)this.snapshot).r();
    }

    private fda createInput(ui nbtTagCompound) {
        return fcy.a(bci.a, (jn.a)this.getRegistryAccess(), nbtTagCompound);
    }

    private fcz createOutput() {
        return fcz.a(bci.a, this.getRegistryAccess());
    }

    public void loadData(ui nbtTagCompound) {
        this.loadData(this.createInput(nbtTagCompound));
    }

    public void loadData(fda input) {
        ((eaz)this.snapshot).b(input);
        this.load(this.snapshot);
    }

    private void copyData(T from, T to2) {
        ui nbtTagCompound = ((eaz)from).b(this.getRegistryAccess());
        ((eaz)to2).b(this.createInput(nbtTagCompound));
    }

    protected T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected eaz getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().c_(this.getPosition());
    }

    public ui getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return ((eaz)this.snapshot).b(this.getRegistryAccess());
    }

    public fda getSnapshotInput() {
        return this.createInput(this.getSnapshotNBT());
    }

    public fcz getItemNBT() {
        this.applyTo(this.snapshot);
        fcz output = this.createOutput();
        ((eaz)this.snapshot).f(output);
        ((eaz)this.snapshot).b(output);
        return output;
    }

    public void addEntityType(fcz nbt) {
        eaz.a(nbt, ((eaz)this.snapshot).q());
    }

    public ui getUpdateNBT() {
        this.applyTo(this.snapshot);
        return ((eaz)this.snapshot).a(this.getRegistryAccess());
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(eaz tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        eaz tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.e();
        }
        return result;
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return ((eaz)this.getSnapshot()).persistentDataContainer;
    }

    @Nullable
    public zw<acq> getUpdatePacket(@NotNull Location location) {
        return new acw(CraftLocation.toBlockPosition(location), ((eaz)this.snapshot).q(), this.getUpdateNBT());
    }

    @Override
    public CraftBlockEntityState<T> copy() {
        return new CraftBlockEntityState<T>(this, null);
    }

    @Override
    public CraftBlockEntityState<T> copy(Location location) {
        return new CraftBlockEntityState<T>(this, location);
    }
}

