/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;

public class CraftCreatureSpawner
extends CraftBlockEntityState<ecr>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, ecr tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state, Location location) {
        super(state, location);
    }

    public EntityType getSpawnedType() {
        dno spawnData = ((ecr)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        Optional<bzv<?>> type = spawnData.a().a("id", bzv.a);
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((ecr)this.getSnapshot()).c().l = bvt.a();
            ((ecr)this.getSnapshot()).c().m = new dno();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        bck rand = this.isPlaced() ? this.getWorldHandle().H_() : bck.a();
        ((ecr)this.getSnapshot()).a(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    public EntitySnapshot getSpawnedEntity() {
        dno spawnData = ((ecr)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(((ecr)this.getSnapshot()).c(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(((ecr)this.getSnapshot()).c(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public static void setSpawnedEntity(dlu spawner, EntitySnapshot snapshot, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        spawner.l = bvt.a();
        if (snapshot == null) {
            spawner.m = new dno();
            return;
        }
        ui compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        spawner.m = new dno(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment));
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(((ecr)this.getSnapshot()).c(), snapshot, weight, spawnRule, null);
    }

    public static void addPotentialSpawn(dlu spawner, EntitySnapshot snapshot, int weight, SpawnRule spawnRule, SpawnerEntry.Equipment equipment) {
        Preconditions.checkArgument((snapshot != null ? 1 : 0) != 0, (Object)"Snapshot cannot be null");
        ui compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        bvt.a<dno> builder = bvt.b();
        spawner.l.d().forEach(entry -> builder.a((dno)entry.a(), entry.b()));
        builder.a(new dno(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnRule)), CraftCreatureSpawner.getEquipment(equipment)), weight);
        spawner.l = builder.a();
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(((ecr)this.getSnapshot()).c(), entries);
    }

    public static void setPotentialSpawns(dlu spawner, Collection<SpawnerEntry> entries) {
        Preconditions.checkArgument((entries != null ? 1 : 0) != 0, (Object)"Entries cannot be null");
        bvt.a<dno> builder = bvt.b();
        for (SpawnerEntry spawnerEntry : entries) {
            ui compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.a(new dno(compoundTag, Optional.ofNullable(CraftCreatureSpawner.toMinecraftRule(spawnerEntry.getSpawnRule())), CraftCreatureSpawner.getEquipment(spawnerEntry.getEquipment())), spawnerEntry.getSpawnWeight());
        }
        spawner.l = builder.a();
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(((ecr)this.getSnapshot()).c());
    }

    public static List<SpawnerEntry> getPotentialSpawns(dlu spawner) {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (bvs<dno> entry : spawner.l.d()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(entry.a().a());
            if (snapshot == null) continue;
            SpawnRule rule = entry.a().e().map(CraftCreatureSpawner::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry((EntitySnapshot)snapshot, entry.b(), rule, CraftCreatureSpawner.getEquipment(entry.a().f())));
        }
        return entries;
    }

    public static dno.a toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new dno.a(new bbt<Integer>(rule.getMinBlockLight(), rule.getMaxBlockLight()), new bbt<Integer>(rule.getMinSkyLight(), rule.getMaxSkyLight()));
    }

    public static SpawnRule fromMinecraftRule(dno.a rule) {
        bbt<Integer> blockLight = rule.a();
        bbt<Integer> skyLight = rule.b();
        return new SpawnRule(blockLight.b().intValue(), blockLight.b().intValue(), skyLight.a().intValue(), skyLight.b().intValue());
    }

    public String getCreatureTypeName() {
        dno spawnData = ((ecr)this.getSnapshot()).c().m;
        if (spawnData == null) {
            return null;
        }
        Optional<bzv<?>> type = spawnData.a().a("id", bzv.a);
        return type.map(CraftEntityType::minecraftToBukkit).map(CraftEntityType::bukkitToString).orElse(null);
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = CraftEntityType.stringToBukkit(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((ecr)this.getSnapshot()).c().k;
    }

    public void setDelay(int delay) {
        ((ecr)this.getSnapshot()).c().k = delay;
    }

    public int getMinSpawnDelay() {
        return ((ecr)this.getSnapshot()).c().p;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((ecr)this.getSnapshot()).c().p = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((ecr)this.getSnapshot()).c().q;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((ecr)this.getSnapshot()).c().q = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((ecr)this.getSnapshot()).c().t;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((ecr)this.getSnapshot()).c().t = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((ecr)this.getSnapshot()).c().r;
    }

    public void setSpawnCount(int count) {
        ((ecr)this.getSnapshot()).c().r = count;
    }

    public int getRequiredPlayerRange() {
        return ((ecr)this.getSnapshot()).c().u;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((ecr)this.getSnapshot()).c().u = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((ecr)this.getSnapshot()).c().v;
    }

    public void setSpawnRange(int spawnRange) {
        ((ecr)this.getSnapshot()).c().v = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this, null);
    }

    @Override
    public CraftCreatureSpawner copy(Location location) {
        return new CraftCreatureSpawner(this, location);
    }

    public static Optional<bzy> getEquipment(SpawnerEntry.Equipment bukkit) {
        if (bukkit == null) {
            return Optional.empty();
        }
        return Optional.of(new bzy(CraftLootTable.bukkitToMinecraft(bukkit.getEquipmentLootTable()), bukkit.getDropChances().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getNMS((EquipmentSlot)entry.getKey()), Map.Entry::getValue))));
    }

    public static SpawnerEntry.Equipment getEquipment(Optional<bzy> optional) {
        return optional.map(nms -> new SpawnerEntry.Equipment(CraftLootTable.minecraftToBukkit(nms.a()), new HashMap<EquipmentSlot, Float>(nms.b().entrySet().stream().collect(Collectors.toMap(entry -> CraftEquipmentSlot.getSlot((bzw)entry.getKey()), Map.Entry::getValue))))).orElse(null);
    }
}

