/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Recipe;

public abstract class CraftFurnace<T extends eam>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T tileEntity) {
        super(world, tileEntity);
    }

    protected CraftFurnace(CraftFurnace<T> state, Location location) {
        super(state, location);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((eam)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((eam)this.getTileEntity());
    }

    public short getBurnTime() {
        return (short)((eam)this.getSnapshot()).y;
    }

    public void setBurnTime(short burnTime) {
        ((eam)this.getSnapshot()).y = burnTime;
        this.data = (eeb)this.data.b(dou.b, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((eam)this.getSnapshot()).A;
    }

    public void setCookTime(short cookTime) {
        ((eam)this.getSnapshot()).A = cookTime;
    }

    public int getCookTimeTotal() {
        return ((eam)this.getSnapshot()).B;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((eam)this.getSnapshot()).B = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        ((eam)this.getSnapshot()).C.reference2IntEntrySet().fastForEach(entrySet -> {
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft(((amd)entrySet.getKey()).a()));
            if (recipe instanceof CookingRecipe) {
                CookingRecipe cookingRecipe = (CookingRecipe)recipe;
                recipesUsed.put((Object)cookingRecipe, (Object)entrySet.getValue());
            }
        });
        return recipesUsed.build();
    }

    @Override
    public abstract CraftFurnace<T> copy();

    @Override
    public abstract CraftFurnace<T> copy(Location var1);
}

