/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Attachable;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.Tripwire;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;

public final class CraftTripwire
extends CraftBlockData
implements Tripwire,
Attachable,
MultipleFacing,
Powerable {
    private static final ees DISARMED = CraftTripwire.getBoolean(dze.class, "disarmed");
    private static final ees ATTACHED = CraftTripwire.getBoolean(dze.class, "attached");
    private static final ees[] FACES = new ees[]{CraftTripwire.getBoolean(dze.class, "north", true), CraftTripwire.getBoolean(dze.class, "east", true), CraftTripwire.getBoolean(dze.class, "south", true), CraftTripwire.getBoolean(dze.class, "west", true), CraftTripwire.getBoolean(dze.class, "up", true), CraftTripwire.getBoolean(dze.class, "down", true)};
    private static final ees POWERED = CraftTripwire.getBoolean(dze.class, "powered");

    public CraftTripwire() {
    }

    public CraftTripwire(eeb state) {
        super(state);
    }

    public boolean isDisarmed() {
        return this.get(DISARMED);
    }

    public void setDisarmed(boolean disarmed) {
        this.set(DISARMED, disarmed);
    }

    public boolean isAttached() {
        return this.get(ATTACHED);
    }

    public void setAttached(boolean attached) {
        this.set(ATTACHED, attached);
    }

    public boolean hasFace(BlockFace face) {
        ees state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        ees state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + String.valueOf(face) + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null || !this.get(FACES[i2]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public boolean isPowered() {
        return this.get(POWERED);
    }

    public void setPowered(boolean powered) {
        this.set(POWERED, powered);
    }
}

