/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.boss;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;

public class CraftDragonBattle
implements DragonBattle {
    private final eib handle;

    public CraftDragonBattle(eib handle) {
        this.handle = handle;
    }

    public EnderDragon getEnderDragon() {
        bzm entity = this.handle.l.b(this.handle.w);
        return entity != null ? (EnderDragon)entity.getBukkitEntity() : null;
    }

    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.k);
    }

    public Location getEndPortalLocation() {
        if (this.handle.y == null) {
            return null;
        }
        return CraftLocation.toBukkit(this.handle.y, (World)this.handle.l.getWorld());
    }

    public boolean generateEndPortal(boolean withPortals) {
        if (this.handle.y != null || this.handle.m() != null) {
            return false;
        }
        this.handle.a(withPortals);
        return true;
    }

    public boolean hasBeenPreviouslyKilled() {
        return this.handle.f();
    }

    public void setPreviouslyKilled(boolean previouslyKilled) {
        this.handle.u = previouslyKilled;
    }

    public void initiateRespawn() {
        this.handle.tryRespawn();
    }

    public boolean initiateRespawn(Collection<EnderCrystal> list) {
        if (this.hasBeenPreviouslyKilled() && this.getRespawnPhase() == DragonBattle.RespawnPhase.NONE) {
            eeg.b shapedetector_shapedetectorcollection;
            if (this.handle.y == null && (shapedetector_shapedetectorcollection = this.handle.m()) == null) {
                this.handle.a(true);
            }
            list = list != null ? new ArrayList<EnderCrystal>(list) : Collections.emptyList();
            list.removeIf(enderCrystal -> {
                if (enderCrystal == null) {
                    return true;
                }
                World world = enderCrystal.getWorld();
                return !((CraftWorld)world).getHandle().equals(this.handle.l);
            });
            return this.handle.respawnDragon(list.stream().map(enderCrystal -> ((CraftEnderCrystal)enderCrystal).getHandle()).collect(Collectors.toList()));
        }
        return false;
    }

    public DragonBattle.RespawnPhase getRespawnPhase() {
        return this.toBukkitRespawnPhase(this.handle.z);
    }

    public boolean setRespawnPhase(DragonBattle.RespawnPhase phase) {
        Preconditions.checkArgument((phase != null && phase != DragonBattle.RespawnPhase.NONE ? 1 : 0) != 0, (String)"Invalid respawn phase provided: %s", (Object)phase);
        if (this.handle.z == null) {
            return false;
        }
        this.handle.a(this.toNMSRespawnPhase(phase));
        return true;
    }

    public void resetCrystals() {
        this.handle.h();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftDragonBattle && ((CraftDragonBattle)obj).handle == this.handle;
    }

    private DragonBattle.RespawnPhase toBukkitRespawnPhase(eia phase) {
        return phase != null ? DragonBattle.RespawnPhase.values()[phase.ordinal()] : DragonBattle.RespawnPhase.NONE;
    }

    private eia toNMSRespawnPhase(DragonBattle.RespawnPhase phase) {
        return phase != DragonBattle.RespawnPhase.NONE ? eia.values()[phase.ordinal()] : null;
    }
}

