/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.damage;

import com.google.common.base.Preconditions;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R5.registry.CraftRegistryItem;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageScaling;
import org.bukkit.damage.DamageType;
import org.bukkit.damage.DeathMessageType;

public class CraftDamageType
extends CraftRegistryItem<byd>
implements DamageType {
    public CraftDamageType(NamespacedKey key, jl<byd> handle) {
        super(key, handle);
    }

    public String getTranslationKey() {
        return ((byd)this.getHandle()).a();
    }

    public DamageScaling getDamageScaling() {
        return CraftDamageType.damageScalingToBukkit(((byd)this.getHandle()).b());
    }

    public DamageEffect getDamageEffect() {
        return CraftDamageEffect.toBukkit(((byd)this.getHandle()).d());
    }

    public DeathMessageType getDeathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(((byd)this.getHandle()).e());
    }

    public float getExhaustion() {
        return ((byd)this.getHandle()).c();
    }

    public NamespacedKey getKey() {
        return this.getKeyOrThrow();
    }

    public static DeathMessageType deathMessageTypeToBukkit(byf deathMessageType) {
        return switch (deathMessageType) {
            case byf.a -> DeathMessageType.DEFAULT;
            case byf.b -> DeathMessageType.FALL_VARIANTS;
            case byf.c -> DeathMessageType.INTENTIONAL_GAME_DESIGN;
            default -> throw new IllegalArgumentException("NMS DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a Bukkit DeathMessageType.");
        };
    }

    public static byf deathMessageTypeToNMS(DeathMessageType deathMessageType) {
        return switch (deathMessageType) {
            case DeathMessageType.DEFAULT -> byf.a;
            case DeathMessageType.FALL_VARIANTS -> byf.b;
            case DeathMessageType.INTENTIONAL_GAME_DESIGN -> byf.c;
            default -> throw new IllegalArgumentException("Bukkit DeathMessageType." + String.valueOf(deathMessageType) + " cannot be converted to a NMS DeathMessageType.");
        };
    }

    public static DamageScaling damageScalingToBukkit(bya damageScaling) {
        return switch (damageScaling) {
            case bya.c -> DamageScaling.ALWAYS;
            case bya.b -> DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER;
            case bya.a -> DamageScaling.NEVER;
            default -> throw new IllegalArgumentException("NMS DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a Bukkit DamageScaling");
        };
    }

    public static bya damageScalingToNMS(DamageScaling damageScaling) {
        return switch (damageScaling) {
            case DamageScaling.ALWAYS -> bya.c;
            case DamageScaling.WHEN_CAUSED_BY_LIVING_NON_PLAYER -> bya.b;
            case DamageScaling.NEVER -> bya.a;
            default -> throw new IllegalArgumentException("Bukkit DamageScaling." + String.valueOf(damageScaling) + " cannot be converted to a NMS DamageScaling");
        };
    }

    public static DamageType minecraftHolderToBukkit(jl<byd> minecraftHolder) {
        return CraftDamageType.minecraftToBukkit(minecraftHolder.a());
    }

    public static jl<byd> bukkitToMinecraftHolder(DamageType bukkitDamageType) {
        Preconditions.checkArgument((bukkitDamageType != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(mn.aR);
        jl<byd> jl2 = registry.e(CraftDamageType.bukkitToMinecraft(bukkitDamageType));
        if (jl2 instanceof jl.c) {
            jl.c holder = (jl.c)jl2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkitDamageType) + ", this can happen if a plugin creates its own damage type with out properly registering it.");
    }

    public static byd bukkitToMinecraft(DamageType bukkitDamageType) {
        return (byd)CraftRegistry.bukkitToMinecraft(bukkitDamageType);
    }

    public static DamageType minecraftToBukkit(byd minecraftDamageType) {
        return (DamageType)CraftRegistry.minecraftToBukkit(minecraftDamageType, mn.aR, Registry.DAMAGE_TYPE);
    }
}

