/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAbstractArrow;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftArrow
extends CraftAbstractArrow
implements Arrow {
    public CraftArrow(CraftServer server, cve entity) {
        super(server, entity);
    }

    @Override
    public cve getHandle() {
        return (cve)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        if (this.hasCustomEffect(effect.getType())) {
            if (!override) {
                return false;
            }
            this.removeCustomEffect(effect.getType());
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().C();
        return true;
    }

    public void clearCustomEffects() {
        der old = this.getHandle().A();
        this.getHandle().a(new der(old.e(), old.f(), List.of(), old.g()));
        this.getHandle().C();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (byq effect : this.getHandle().A().d()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (byq effect : this.getHandle().A().d()) {
            if (!CraftPotionUtil.equals(effect.c(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().A().d().isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        if (!this.hasCustomEffect(effect)) {
            return false;
        }
        jl<byo> minecraft = CraftPotionEffectType.bukkitToMinecraftHolder(effect);
        der old = this.getHandle().A();
        this.getHandle().a(new der(old.e(), old.f(), old.d().stream().filter(mobEffect -> !mobEffect.c().equals(minecraft)).toList(), old.g()));
        return true;
    }

    public void setBasePotionData(PotionData data) {
        this.setBasePotionType(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getBasePotionType());
    }

    public void setBasePotionType(PotionType potionType) {
        if (potionType != null) {
            this.getHandle().a(this.getHandle().A().b(CraftPotionType.bukkitToMinecraftHolder(potionType)));
        } else {
            der old = this.getHandle().A();
            this.getHandle().a(new der(Optional.empty(), old.f(), old.d(), old.g()));
        }
    }

    public PotionType getBasePotionType() {
        return this.getHandle().A().e().map(CraftPotionType::minecraftHolderToBukkit).orElse(null);
    }

    public void setColor(Color color) {
        int colorRGB = color == null ? -1 : color.asRGB();
        der old = this.getHandle().A();
        this.getHandle().a(new der(old.e(), Optional.of(colorRGB), old.d(), old.g()));
    }

    public Color getColor() {
        if (this.getHandle().x() <= -1) {
            return null;
        }
        return Color.fromRGB((int)this.getHandle().x());
    }
}

