/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAbstractCow;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionUtil;
import org.bukkit.entity.MushroomCow;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftMushroomCow
extends CraftAbstractCow
implements MushroomCow {
    public CraftMushroomCow(CraftServer server, cmw entity) {
        super(server, entity);
    }

    public boolean hasEffectsForNextStew() {
        dfx stewEffects = this.getHandle().co;
        return stewEffects != null && !stewEffects.a().isEmpty();
    }

    public List<PotionEffect> getEffectsForNextStew() {
        dfx stewEffects = this.getHandle().co;
        if (stewEffects != null) {
            return stewEffects.a().stream().map(recordSuspiciousEffect -> CraftPotionUtil.toBukkit(recordSuspiciousEffect.a())).toList();
        }
        return ImmutableList.of();
    }

    public boolean addEffectToNextStew(PotionEffect potionEffect, boolean overwrite) {
        Preconditions.checkArgument((potionEffect != null ? 1 : 0) != 0, (Object)"PotionEffect cannot be null");
        byq minecraftPotionEffect = CraftPotionUtil.fromBukkit(potionEffect);
        if (!overwrite && this.hasEffectForNextStew(potionEffect.getType())) {
            return false;
        }
        dfx stewEffects = this.getHandle().co;
        if (stewEffects == null) {
            stewEffects = dfx.a;
        }
        dfx.a recordSuspiciousEffect = new dfx.a(minecraftPotionEffect.c(), minecraftPotionEffect.d());
        this.removeEffectFromNextStew(potionEffect.getType());
        this.getHandle().co = stewEffects.a(recordSuspiciousEffect);
        return true;
    }

    public boolean removeEffectFromNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        if (!this.hasEffectForNextStew(potionEffectType)) {
            return false;
        }
        dfx stewEffects = this.getHandle().co;
        if (stewEffects == null) {
            return false;
        }
        jl<byo> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        this.getHandle().co = new dfx(stewEffects.a().stream().filter(effect -> !effect.b().equals(minecraftPotionEffectType)).toList());
        return true;
    }

    public boolean hasEffectForNextStew(PotionEffectType potionEffectType) {
        Preconditions.checkArgument((potionEffectType != null ? 1 : 0) != 0, (Object)"potionEffectType cannot be null");
        dfx stewEffects = this.getHandle().co;
        if (stewEffects == null) {
            return false;
        }
        jl<byo> minecraftPotionEffectType = CraftPotionEffectType.bukkitToMinecraftHolder(potionEffectType);
        return stewEffects.a().stream().anyMatch(recordSuspiciousEffect -> recordSuspiciousEffect.b().equals(minecraftPotionEffectType));
    }

    public void clearEffectsForNextStew() {
        this.getHandle().co = null;
    }

    @Override
    public cmw getHandle() {
        return (cmw)this.entity;
    }

    public MushroomCow.Variant getVariant() {
        return MushroomCow.Variant.values()[this.getHandle().n().ordinal()];
    }

    public void setVariant(MushroomCow.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"Variant cannot be null");
        this.getHandle().a(cmw.a.values()[variant.ordinal()]);
    }

    @Override
    public String toString() {
        return "CraftMushroomCow";
    }
}

