/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R5.registry.CraftRegistryItem;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, cna entity) {
        super(server, entity);
    }

    public boolean hasSaddle() {
        return this.getHandle().gm();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().a(bzw.h, saddled ? new dcv(dcz.ov) : dcv.l);
    }

    public int getBoostTicks() {
        return this.getHandle().cm.e ? this.getHandle().cm.d() : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().cm.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().cm.e ? this.getHandle().cm.f : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().cm.e) {
            return;
        }
        int max = this.getHandle().cm.d();
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().cm.f = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    public Pig.Variant getVariant() {
        return CraftVariant.minecraftHolderToBukkit(this.getHandle().n());
    }

    public void setVariant(Pig.Variant variant) {
        Preconditions.checkArgument((variant != null ? 1 : 0) != 0, (Object)"variant");
        this.getHandle().b(CraftVariant.bukkitToMinecraftHolder(variant));
    }

    @Override
    public cna getHandle() {
        return (cna)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }

    public static class CraftVariant
    extends CraftRegistryItem<cnb>
    implements Pig.Variant {
        public static Pig.Variant minecraftToBukkit(cnb minecraft) {
            return (Pig.Variant)CraftRegistry.minecraftToBukkit(minecraft, mn.bf, Registry.PIG_VARIANT);
        }

        public static Pig.Variant minecraftHolderToBukkit(jl<cnb> minecraft) {
            return CraftVariant.minecraftToBukkit(minecraft.a());
        }

        public static cnb bukkitToMinecraft(Pig.Variant bukkit) {
            return (cnb)CraftRegistry.bukkitToMinecraft(bukkit);
        }

        public static jl<cnb> bukkitToMinecraftHolder(Pig.Variant bukkit) {
            return CraftRegistry.bukkitToMinecraftHolder(bukkit, mn.bf);
        }

        public CraftVariant(NamespacedKey key, jl<cnb> handle) {
            super(key, handle);
        }

        public NamespacedKey getKey() {
            return this.getKeyOrThrow();
        }
    }
}

