/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.Sniffer;

public class CraftSniffer
extends CraftAnimals
implements Sniffer {
    public CraftSniffer(CraftServer server, cpg entity) {
        super(server, entity);
    }

    @Override
    public cpg getHandle() {
        return (cpg)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftSniffer";
    }

    public Collection<Location> getExploredLocations() {
        return this.getHandle().gZ().map(blockPosition -> CraftLocation.toBukkit(blockPosition.b(), this.server.getServer().a(blockPosition.a()))).collect(Collectors.toList());
    }

    public void removeExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        jb blockPosition = CraftLocation.toBlockPosition(location);
        this.getHandle().eh().a(cjo.aR, this.getHandle().gZ().filter(blockPositionExplored -> !blockPositionExplored.equals(blockPosition)).collect(Collectors.toList()));
    }

    public void addExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        this.getHandle().i(CraftLocation.toBlockPosition(location));
    }

    public Sniffer.State getState() {
        return this.stateToBukkit(this.getHandle().gU());
    }

    public void setState(Sniffer.State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.getHandle().a(this.stateToNMS(state));
    }

    public Location findPossibleDigLocation() {
        return this.getHandle().gJ().map(blockPosition -> CraftLocation.toBukkit(blockPosition, this.getLocation().getWorld())).orElse(null);
    }

    public boolean canDig() {
        return this.getHandle().gK();
    }

    private cpg.a stateToNMS(Sniffer.State state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case Sniffer.State.IDLING -> cpg.a.a;
            case Sniffer.State.FEELING_HAPPY -> cpg.a.b;
            case Sniffer.State.SCENTING -> cpg.a.c;
            case Sniffer.State.SNIFFING -> cpg.a.d;
            case Sniffer.State.SEARCHING -> cpg.a.e;
            case Sniffer.State.DIGGING -> cpg.a.f;
            case Sniffer.State.RISING -> cpg.a.g;
        };
    }

    private Sniffer.State stateToBukkit(cpg.a state) {
        return switch (state) {
            default -> throw new MatchException(null, null);
            case cpg.a.a -> Sniffer.State.IDLING;
            case cpg.a.b -> Sniffer.State.FEELING_HAPPY;
            case cpg.a.c -> Sniffer.State.SCENTING;
            case cpg.a.d -> Sniffer.State.SNIFFING;
            case cpg.a.e -> Sniffer.State.SEARCHING;
            case cpg.a.f -> Sniffer.State.DIGGING;
            case cpg.a.g -> Sniffer.State.RISING;
        };
    }
}

