/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMonster;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wither;

public class CraftWither
extends CraftMonster
implements Wither {
    private BossBar bossBar;

    public CraftWither(CraftServer server, cqm entity) {
        super(server, entity);
        if (entity.cs != null) {
            this.bossBar = new CraftBossBar(entity.cs);
        }
    }

    @Override
    public cqm getHandle() {
        return (cqm)this.entity;
    }

    @Override
    public String toString() {
        return "CraftWither";
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public void setTarget(Wither.Head head, LivingEntity livingEntity) {
        Preconditions.checkArgument((head != null ? 1 : 0) != 0, (Object)"head cannot be null");
        int entityId = livingEntity != null ? livingEntity.getEntityId() : 0;
        this.getHandle().a(head.ordinal(), entityId);
    }

    public LivingEntity getTarget(Wither.Head head) {
        Preconditions.checkArgument((head != null ? 1 : 0) != 0, (Object)"head cannot be null");
        int entityId = this.getHandle().c(head.ordinal());
        if (entityId == 0) {
            return null;
        }
        bzm target = this.getHandle().ai().a(entityId);
        return target != null ? (LivingEntity)target.getBukkitEntity() : null;
    }

    public int getInvulnerabilityTicks() {
        return this.getHandle().gH();
    }

    public void setInvulnerabilityTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >=0");
        this.getHandle().b(ticks);
    }
}

